/*
 * Decompiled with CFR 0.152.
 */
package etm.contrib.integration.cdi;

import etm.contrib.integration.cdi.Measure;
import etm.core.configuration.EtmManager;
import etm.core.monitor.EtmPoint;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;

@Interceptor
@Measure
public class EtmInterceptor
implements Serializable {
    private transient Map<Method, String> methodNameCache = new ConcurrentHashMap<Method, String>();
    private transient Map<Class, String> classNameCache = new ConcurrentHashMap<Class, String>();
    private Set<Class> proxyClasses = new HashSet<Class>();
    private static final String[] PROXY_CLASSES = new String[]{"javassist.util.proxy.ProxyObject", "org.jboss.weld.bean.proxy.ProxyObject"};

    public EtmInterceptor() {
        for (String className : PROXY_CLASSES) {
            try {
                this.proxyClasses.add(Class.forName(className));
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
    }

    @AroundInvoke
    public Object measure(InvocationContext ctx) throws Exception {
        String targetMethod = this.calculateMethodName(ctx);
        EtmPoint point = EtmManager.getEtmMonitor().createPoint(targetMethod);
        try {
            Object object = ctx.proceed();
            return object;
        }
        catch (Exception e) {
            point.alterName(targetMethod + "[ " + e.getClass().getSimpleName() + "]");
            throw e;
        }
        finally {
            point.collect();
        }
    }

    protected String calculateMethodName(InvocationContext ctx) {
        Class<?> targetClass = ctx.getTarget().getClass();
        Method method = ctx.getMethod();
        String name = this.methodNameCache.get(method);
        if (name == null) {
            Class<?>[] parameterTypes;
            StringBuilder buffer = new StringBuilder();
            buffer.append(this.calculateClassName(targetClass));
            buffer.append(':');
            buffer.append(method.getName());
            buffer.append('(');
            for (Class<?> clazz : parameterTypes = method.getParameterTypes()) {
                buffer.append(clazz.getSimpleName());
                buffer.append(",");
            }
            if (parameterTypes.length > 0) {
                buffer.setCharAt(buffer.length() - 1, ')');
            } else {
                buffer.append(')');
            }
            name = buffer.toString();
            this.methodNameCache.put(method, name);
        }
        return name;
    }

    protected String calculateClassName(Class clazz) {
        String className = this.classNameCache.get(clazz);
        if (className == null) {
            className = clazz.isSynthetic() || this.isProxy(clazz) ? clazz.getSuperclass().getSimpleName() : clazz.getSimpleName();
            this.classNameCache.put(clazz, className);
        }
        return className;
    }

    private boolean isProxy(Class aTargetClass) {
        for (Class<?> clazz : aTargetClass.getInterfaces()) {
            if (!this.proxyClasses.contains(clazz)) continue;
            return true;
        }
        return false;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.classNameCache = new ConcurrentHashMap<Class, String>();
        this.methodNameCache = new ConcurrentHashMap<Method, String>();
    }
}

