/*
 * Decompiled with CFR 0.152.
 */
package etm.contrib.integration.jee.jsf;

import etm.core.configuration.EtmManager;
import etm.core.monitor.EtmPoint;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseListener;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import javax.servlet.http.HttpServletRequest;

public class DelegatingEtmLifecycleFactory
extends LifecycleFactory {
    private LifecycleFactory delegate;
    private Map<String, Lifecycle> interceptedLifeCycles = new ConcurrentHashMap<String, Lifecycle>();

    public DelegatingEtmLifecycleFactory(LifecycleFactory aDelegate) {
        this.delegate = aDelegate;
    }

    public void addLifecycle(String lifecycleId, Lifecycle lifecycle) {
        this.delegate.addLifecycle(lifecycleId, lifecycle);
    }

    public Lifecycle getLifecycle(String lifecycleId) {
        Lifecycle lifecycle = this.interceptedLifeCycles.get(lifecycleId);
        if (lifecycle == null) {
            Lifecycle defaultLifeCycle = this.delegate.getLifecycle(lifecycleId);
            lifecycle = new InterceptedLifeCycle(defaultLifeCycle);
            this.interceptedLifeCycles.put(lifecycleId, lifecycle);
        }
        return lifecycle;
    }

    public Iterator<String> getLifecycleIds() {
        return this.delegate.getLifecycleIds();
    }

    static class InterceptedLifeCycle
    extends Lifecycle {
        private Lifecycle delegate;

        InterceptedLifeCycle(Lifecycle aDelegate) {
            this.delegate = aDelegate;
        }

        public void addPhaseListener(PhaseListener listener) {
            this.delegate.addPhaseListener(listener);
        }

        public void execute(FacesContext context) throws FacesException {
            EtmPoint requestPoint = EtmManager.getEtmMonitor().createPoint(this.getDefaultRequestName(context));
            context.getAttributes().put("ETM__RootRequestPoint", requestPoint);
            this.delegate.execute(context);
        }

        public PhaseListener[] getPhaseListeners() {
            return this.delegate.getPhaseListeners();
        }

        public void removePhaseListener(PhaseListener listener) {
            this.delegate.removePhaseListener(listener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void render(FacesContext context) throws FacesException {
            try {
                this.delegate.render(context);
            }
            finally {
                EtmPoint requestPoint = (EtmPoint)context.getAttributes().get("ETM__RootRequestPoint");
                if (requestPoint != null) {
                    requestPoint.collect();
                    context.getAttributes().remove("ETM__RootRequestPoint");
                }
            }
        }

        protected String getDefaultRequestName(FacesContext context) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)context.getExternalContext().getRequest();
            String request = httpServletRequest.getRequestURI();
            int index = request.indexOf(59);
            if (index > 0) {
                request = request.substring(0, index);
            }
            String method = httpServletRequest.getMethod();
            return "HTTP " + method + " " + request;
        }
    }
}

