/*
 * Decompiled with CFR 0.152.
 */
package etm.contrib.integration.jee.rest;

import etm.core.configuration.EtmManager;
import etm.core.monitor.EtmMonitor;
import etm.core.monitor.EtmPoint;
import java.io.IOException;
import java.lang.reflect.Method;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Path;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.ext.Provider;

@Provider
public class JaxrsRequestPerformanceFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    public static final String JETM_JAXRS_POINT = "jetm.jaxrs.point";
    @Context
    private HttpServletRequest request;
    @Context
    private ResourceInfo resourceInfo;
    private final EtmMonitor etmMonitor = this.getEtmMonitor();
    private String contextPath;
    private String servletPath;

    @PostConstruct
    private void init() {
        this.contextPath = this.request.getContextPath();
        this.servletPath = this.request.getServletPath();
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        EtmPoint point = this.etmMonitor.createPoint("HTTP " + this.request.getMethod() + " request " + this.getPath());
        this.request.setAttribute(JETM_JAXRS_POINT, (Object)point);
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        EtmPoint point = (EtmPoint)this.request.getAttribute(JETM_JAXRS_POINT);
        if (point != null) {
            point.collect();
        }
    }

    protected EtmMonitor getEtmMonitor() {
        return EtmManager.getEtmMonitor();
    }

    protected String getPath() {
        UriBuilder uriBuilder = UriBuilder.fromPath((String)this.contextPath).path(this.servletPath);
        Method resourceMethod = this.resourceInfo.getResourceMethod();
        if (resourceMethod.getDeclaringClass().isAnnotationPresent(Path.class)) {
            Path classLevelPath = resourceMethod.getDeclaringClass().getAnnotation(Path.class);
            uriBuilder.path(classLevelPath.value());
        }
        if (resourceMethod.isAnnotationPresent(Path.class)) {
            Path methodLevelPath = resourceMethod.getAnnotation(Path.class);
            uriBuilder.path(methodLevelPath.value());
        }
        return uriBuilder.toTemplate();
    }
}

