/*
 * Decompiled with CFR 0.152.
 */
package etm.contrib.integration.jca;

import etm.contrib.integration.jca.EtmMonitorReference;
import etm.contrib.integration.jca.EtmMonitorRepository;
import etm.core.configuration.EtmManager;
import etm.core.configuration.EtmMonitorConfig;
import etm.core.configuration.EtmMonitorFactory;
import etm.core.configuration.XmlConfigParser;
import etm.core.configuration.XmlEtmConfigurator;
import etm.core.monitor.EtmMonitor;
import etm.core.util.Log;
import etm.core.util.LogAdapter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.resource.Referenceable;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.xa.XAResource;

public class EtmMonitorConnector
implements ResourceAdapter,
Referenceable,
Serializable {
    private static final LogAdapter LOG = Log.getLog((Class)EtmMonitorConnector.class);
    private static final String DEFAULT_CONFIG_FILE_NAME = "jetm-config.xml";
    private String configFileName = "jetm-config.xml";
    private String jndiName;
    private Reference reference;

    public void setConfigFile(String fileName) {
        this.configFileName = fileName;
    }

    public void setJndiName(String aJndiName) {
        this.jndiName = aJndiName;
    }

    public void start(BootstrapContext aBootstrapContext) throws ResourceAdapterInternalException {
        ClassLoader loader = EtmMonitor.class.getClassLoader();
        URL resource = loader.getResource(this.configFileName);
        if (resource == null) {
            throw new ResourceAdapterInternalException("Unable to locate JETM config file " + this.configFileName + " in classpath.");
        }
        LOG.debug("Using JETM configuration file " + resource);
        if (this.jndiName == null) {
            XmlEtmConfigurator.configure((URL)resource);
            EtmManager.getEtmMonitor().start();
        } else {
            InputStream in = null;
            InitialContext ctx = null;
            try {
                in = resource.openStream();
                EtmMonitorConfig monitorConfig = XmlConfigParser.extractConfig((InputStream)in);
                EtmMonitor monitor = EtmMonitorFactory.createEtmMonitor((EtmMonitorConfig)monitorConfig);
                ctx = new InitialContext();
                EtmMonitorReference etmMonitorReference = new EtmMonitorReference();
                etmMonitorReference.setReference(resource.toString());
                ctx.bind(this.jndiName, (Object)etmMonitorReference);
                EtmMonitorRepository.register(resource.toString(), monitor);
                monitor.start();
            }
            catch (Exception e) {
                throw new ResourceAdapterInternalException((Throwable)e);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {}
                }
                if (ctx != null) {
                    try {
                        ctx.close();
                    }
                    catch (NamingException e) {}
                }
            }
        }
        this.reference = new Reference(EtmMonitorConnector.class.getName(), new StringRefAddr("configfile", resource.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.jndiName == null) {
            EtmManager.getEtmMonitor().stop();
        } else {
            EtmMonitor monitor = EtmMonitorRepository.getMonitor((String)this.reference.get("configfile").getContent());
            monitor.stop();
            InitialContext ctx = null;
            try {
                ctx = new InitialContext();
                ctx.unbind(this.jndiName);
            }
            catch (NameNotFoundException e) {
            }
            catch (Exception e) {
                LOG.warn("Unable to deregister JETM monitor " + this.jndiName + " from JNDI tree", (Throwable)e);
            }
            finally {
                if (ctx != null) {
                    try {
                        ctx.close();
                    }
                    catch (NamingException namingException) {}
                }
            }
        }
    }

    public void endpointActivation(MessageEndpointFactory aMessageEndpointFactory, ActivationSpec aActivationSpec) throws ResourceException {
    }

    public void endpointDeactivation(MessageEndpointFactory aMessageEndpointFactory, ActivationSpec aActivationSpec) {
    }

    public XAResource[] getXAResources(ActivationSpec[] aActivationSpecs) throws ResourceException {
        return null;
    }

    public Reference getReference() throws NamingException {
        return this.reference;
    }

    public void setReference(Reference aReference) {
        throw new UnsupportedOperationException("Not supported.");
    }
}

