/*
 * Decompiled with CFR 0.152.
 */
package etm.contrib.rrd.core;

import etm.contrib.rrd.core.OfflineExecution;
import etm.contrib.rrd.core.RrdDestination;
import etm.core.util.Log;
import etm.core.util.LogAdapter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OfflineLogParser {
    private static final LogAdapter LOG = Log.getLog((Class)OfflineLogParser.class);
    private static final String DEFAULT_SCAN_PATTERN = "^(.*)measurementPoint=<([\\w\\s\\d]*)>, parent=<([\\w\\s]*)>, transactionTime=<(\\d*[,.]\\d*)>, recordingTime=<(\\d*)>";
    private String pattern = "^(.*)measurementPoint=<([\\w\\s\\d]*)>, parent=<([\\w\\s]*)>, transactionTime=<(\\d*[,.]\\d*)>, recordingTime=<(\\d*)>";
    private List destinations = new ArrayList();
    private DecimalFormat numberFormat = new DecimalFormat();

    public OfflineLogParser() {
        this.numberFormat.setMinimumFractionDigits(3);
        this.numberFormat.setMaximumFractionDigits(3);
        this.numberFormat.setGroupingUsed(false);
    }

    public void setPattern(String aPattern) {
        this.pattern = aPattern;
    }

    public void register(RrdDestination aDestination) {
        this.destinations.add(aDestination);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(File aFile) throws IOException {
        LOG.info("Parsing " + aFile.getAbsolutePath());
        boolean checkDecimalDigit = true;
        int totalLines = 0;
        int processedLines = 0;
        Pattern regex = Pattern.compile(this.pattern);
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(aFile), "UTF-8"));
        try {
            String line;
            for (int i = 0; i < this.destinations.size(); ++i) {
                RrdDestination destination = (RrdDestination)this.destinations.get(i);
                destination.start();
            }
            while ((line = in.readLine()) != null) {
                ++totalLines;
                try {
                    Matcher matcher = regex.matcher(line);
                    if (!matcher.matches()) continue;
                    if (checkDecimalDigit) {
                        DecimalFormatSymbols symbols = this.numberFormat.getDecimalFormatSymbols();
                        if (matcher.group(4).indexOf(symbols.getDecimalSeparator()) < 0) {
                            LOG.warn("Possibly precision loss detected. Expected decimal separator '" + symbols.getDecimalSeparator() + "', but found " + matcher.group(4) + ". Use -Duser.language and -Duser.region to adjust your locale to the logfile locale.");
                        }
                        checkDecimalDigit = false;
                    }
                    ++processedLines;
                    OfflineExecution result = new OfflineExecution(matcher.group(2), matcher.group(3), Long.parseLong(matcher.group(5)), this.numberFormat.parse(matcher.group(4)).doubleValue());
                    for (int i = 0; i < this.destinations.size(); ++i) {
                        RrdDestination destination = (RrdDestination)this.destinations.get(i);
                        if (!destination.matches(result)) continue;
                        destination.write(result);
                    }
                }
                catch (ParseException e) {
                    LOG.warn("Error reading line " + line, (Throwable)e);
                }
            }
            for (int i = 0; i < this.destinations.size(); ++i) {
                RrdDestination destination = (RrdDestination)this.destinations.get(i);
                destination.stop();
            }
        }
        finally {
            in.close();
        }
        LOG.debug("Finished parsing " + aFile.getAbsolutePath() + ". Processed " + processedLines + " out of " + totalLines + " lines.");
    }
}

