/*
 * Decompiled with CFR 0.152.
 */
package etm.contrib.rrd.rrd4j;

import etm.contrib.rrd.rrd4j.Rrd4jUtil;
import etm.core.metadata.PluginMetaData;
import etm.core.monitor.EtmMonitorContext;
import etm.core.plugin.EtmPlugin;
import java.net.URL;
import java.util.Date;
import java.util.Map;
import java.util.TimerTask;
import org.rrd4j.core.Util;

public class Rrd4jImageGeneratorPlugin
implements EtmPlugin {
    private long generationInterval = 5000L;
    private String templateName;
    private Map templateProperties;
    private int renderInterval = 3600;
    private int offset;
    private static final long DEFAULT_INTERVAL = 5000L;
    private ImageTask task;
    private EtmMonitorContext ctx;

    public void setGenerationInterval(long aGenerationInterval) {
        this.generationInterval = aGenerationInterval * 1000L;
    }

    public void setTemplateName(String aTemplateName) {
        this.templateName = aTemplateName;
    }

    public void setTemplateProperties(Map aProperties) {
        this.templateProperties = aProperties;
    }

    public void setRenderInterval(int aRenderInterval) {
        this.renderInterval = aRenderInterval;
    }

    public void setOffset(int aOffset) {
        this.offset = aOffset;
    }

    public void init(EtmMonitorContext aCtx) {
        this.ctx = aCtx;
    }

    public void start() {
        this.task = new ImageTask();
        this.ctx.getScheduler().schedule((TimerTask)this.task, 0L, this.generationInterval);
    }

    public void stop() {
        if (this.task != null) {
            this.task.cancel();
        }
    }

    public PluginMetaData getPluginMetaData() {
        PluginMetaData metaData = new PluginMetaData(this.getClass(), "Rrd4jImageGenerator Plugin .");
        return metaData;
    }

    class ImageTask
    extends TimerTask {
        private URL template;
        Rrd4jUtil util = new Rrd4jUtil();

        public ImageTask() {
            this.template = this.util.locateTemplate(Rrd4jImageGeneratorPlugin.this.templateName);
        }

        public void run() {
            long intervalend = Util.getTimestamp((Date)new Date());
            long intervalstart = intervalend - (long)Rrd4jImageGeneratorPlugin.this.offset - (long)Rrd4jImageGeneratorPlugin.this.renderInterval;
            this.util.createGraph(this.template, intervalstart, intervalend, Rrd4jImageGeneratorPlugin.this.templateProperties);
        }
    }
}

