/*
 * Decompiled with CFR 0.152.
 */
package etm.contrib.rrd.rrd4j;

import etm.core.monitor.EtmException;
import etm.core.monitor.EtmMonitor;
import etm.core.util.Log;
import etm.core.util.LogAdapter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.rrd4j.core.RrdDb;
import org.rrd4j.core.RrdDef;
import org.rrd4j.core.RrdDefTemplate;
import org.rrd4j.core.XmlTemplate;
import org.rrd4j.graph.RrdGraph;
import org.rrd4j.graph.RrdGraphDef;
import org.rrd4j.graph.RrdGraphDefTemplate;
import org.rrd4j.graph.RrdGraphInfo;
import org.xml.sax.InputSource;

public class Rrd4jUtil {
    public static final String IMAGE_DESTINATION_FILE_VARIABLE = "imagefile";
    public static final String RRD_FILE_VARIABLE = "rrdfile";
    public static final String INTERVALSTART_VARIABLE = "intervalstart";
    public static final String INTERVALEND_VARIABLE = "intervalend";
    private static final LogAdapter LOG = Log.getLog((Class)Rrd4jUtil.class);
    private static Map templates = new HashMap();

    public void createGraph(URL templateUrl, File rrdFile, File destination, long intervalStart, long intervalEnd, Map properties) {
        if (properties == null) {
            properties = new HashMap<String, String>();
        }
        properties.put(RRD_FILE_VARIABLE, rrdFile.getAbsolutePath());
        this.createGraph(templateUrl, destination, intervalStart, intervalEnd, properties);
    }

    public void createGraph(URL templateUrl, File destination, long intervalStart, long intervalEnd, Map properties) {
        if (properties == null) {
            properties = new HashMap<String, String>();
        }
        properties.put(IMAGE_DESTINATION_FILE_VARIABLE, destination.getAbsolutePath());
        File parentDir = destination.getParentFile();
        if (!parentDir.exists() && !parentDir.mkdirs()) {
            LOG.warn("Unable to create directory " + parentDir.getAbsolutePath() + ". Aborting.");
            return;
        }
        this.createGraph(templateUrl, intervalStart, intervalEnd, properties);
    }

    public void createGraph(URL templateUrl, long intervalStart, long intervalEnd, Map properties) {
        if (properties == null) {
            properties = new HashMap<String, Long>();
        }
        properties.put(INTERVALSTART_VARIABLE, new Long(intervalStart));
        properties.put(INTERVALEND_VARIABLE, new Long(intervalEnd));
        this.createGraph(templateUrl, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createGraph(URL templateUrl, Map properties) {
        this.setImageDefaults(properties);
        try {
            URLConnection connection = templateUrl.openConnection();
            InputStream in = connection.getInputStream();
            try {
                RrdGraphDefTemplate template = new RrdGraphDefTemplate(new InputSource(in));
                this.setProperties((XmlTemplate)template, properties);
                RrdGraphDef graphDef = template.getRrdGraphDef();
                RrdGraphInfo info = new RrdGraph(graphDef).getRrdGraphInfo();
                LOG.info("Created image " + info.getFilename() + " [" + info.getWidth() + "x" + info.getHeight() + ", " + info.getBytes().length + " bytes" + "]");
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
        catch (IOException e) {
            throw new EtmException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createRrdDb(URL templateUrl, File rrdFile, Map properties) {
        if (rrdFile.exists()) {
            throw new EtmException("Unable to create rrd file at " + rrdFile.getAbsolutePath() + ". File already available.");
        }
        File parentDir = rrdFile.getParentFile();
        if (parentDir != null && !parentDir.exists() && !parentDir.mkdirs()) {
            throw new EtmException("Unable to create rrd directory " + parentDir.getAbsolutePath());
        }
        if (properties == null) {
            properties = new HashMap<String, String>();
        }
        properties.put(RRD_FILE_VARIABLE, rrdFile.getAbsolutePath());
        try {
            URLConnection connection = templateUrl.openConnection();
            InputStream in = connection.getInputStream();
            try {
                RrdDefTemplate template = new RrdDefTemplate(new InputSource(in));
                this.setProperties((XmlTemplate)template, properties);
                RrdDef rrdDef = template.getRrdDef();
                RrdDb db = new RrdDb(rrdDef);
                db.close();
                LOG.info("Created rrd db at " + rrdFile.getAbsolutePath() + " using template " + templateUrl + ".");
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
        catch (Exception e) {
            throw new EtmException((Throwable)e);
        }
    }

    public URL locateTemplate(String aTemplate) {
        ClassLoader loader;
        URL resource;
        if (templates.containsKey(aTemplate)) {
            aTemplate = (String)templates.get(aTemplate);
            LOG.debug("Using template " + aTemplate + " from classpath.");
        }
        if ((resource = (loader = EtmMonitor.class.getClassLoader()).getResource(aTemplate)) != null) {
            return resource;
        }
        File file = new File(aTemplate);
        if (file.exists()) {
            try {
                return file.toURL();
            }
            catch (MalformedURLException e) {
                throw new EtmException((Throwable)e);
            }
        }
        throw new EtmException("Unable to locate template " + aTemplate + " in ClassPath or Filesystem.");
    }

    private void setProperties(XmlTemplate aTemplate, Map properties) {
        Iterator it = properties.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            Object value = properties.get(key);
            if (value instanceof String) {
                aTemplate.setVariable(key, (String)value);
                continue;
            }
            if (value instanceof Calendar) {
                aTemplate.setVariable(key, (Calendar)value);
                continue;
            }
            if (value instanceof Long) {
                aTemplate.setVariable(key, ((Long)value).longValue());
                continue;
            }
            if (value instanceof Date) {
                aTemplate.setVariable(key, (Date)value);
                continue;
            }
            aTemplate.setVariable(key, String.valueOf(value));
        }
    }

    private void setImageDefaults(Map properties) {
        if (properties.get("logarithmic") == null) {
            properties.put("logarithmic", "false");
        }
        DateFormat format = SimpleDateFormat.getInstance();
        if (properties.get(INTERVALSTART_VARIABLE) != null && properties.get(INTERVALEND_VARIABLE) != null) {
            Long start = (Long)properties.get(INTERVALSTART_VARIABLE);
            Long end = (Long)properties.get(INTERVALEND_VARIABLE);
            Date startDate = new Date(start * 1000L);
            Date endDate = new Date(end * 1000L);
            properties.put("generatedstamp", "Monitoring period: " + format.format(startDate) + " - " + format.format(endDate) + " [Generated " + format.format(new Date()) + "]\\r");
        } else {
            properties.put("generatedstamp", "Generated " + format.format(new Date()) + "\\r");
        }
        if (properties.get("imagetitle") == null) {
            properties.put("imagetitle", "Current performance results");
        }
    }

    static {
        templates.put("highres", "etm/contrib/rrd/rrd4j/template/db/highres-template.xml");
        templates.put("mediumres", "etm/contrib/rrd/rrd4j/template/db/mediumres-template.xml");
        templates.put("lowres", "etm/contrib/rrd/rrd4j/template/db/lowres-template.xml");
        templates.put("average-tx", "etm/contrib/rrd/rrd4j/template/graph/average-and-tx-template.xml");
        templates.put("min-average", "etm/contrib/rrd/rrd4j/template/graph/min-average-template.xml");
        templates.put("max-average", "etm/contrib/rrd/rrd4j/template/graph/max-average-template.xml");
        templates.put("average", "etm/contrib/rrd/rrd4j/template/graph/average-template.xml");
        templates.put("min", "etm/contrib/rrd/rrd4j/template/graph/min-template.xml");
        templates.put("max", "etm/contrib/rrd/rrd4j/template/graph/max-template.xml");
        templates.put("tx", "etm/contrib/rrd/rrd4j/template/graph/tx-template.xml");
    }
}

