/*
 * Decompiled with CFR 0.152.
 */
package etm.contrib.integration.web;

import etm.core.configuration.EtmConfigurationException;
import etm.core.configuration.EtmManager;
import etm.core.configuration.XmlEtmConfigurator;
import etm.core.monitor.EtmMonitor;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

public class EtmMonitorContextListener
implements ServletContextListener {
    private static final String DEFAULT_CONFIG_FILE = "jetm-config.xml";
    private static final String CONTEXT_FILE_NAME = "jetm.config.filename";
    private static final String CONTEXT_FILE_PATH = "jetm.config.filepath";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void contextInitialized(ServletContextEvent servletContextEvent) {
        String key;
        ServletContext ctx = servletContextEvent.getServletContext();
        String fileName = ctx.getInitParameter(CONTEXT_FILE_NAME);
        String filePath = ctx.getInitParameter(CONTEXT_FILE_PATH);
        if (filePath != null && filePath.startsWith("${") && filePath.endsWith("}") && (filePath = System.getProperty(key = filePath.substring(2, filePath.length() - 1))) == null) {
            throw new EtmConfigurationException("Error reading jetm config filepath from System properties using name " + key);
        }
        if (fileName == null) {
            fileName = DEFAULT_CONFIG_FILE;
        }
        if (filePath != null) {
            File file = new File(filePath, fileName);
            if (!file.canRead()) throw new EtmConfigurationException("Unable to locate JETM configuration file at " + file.getAbsolutePath());
            try {
                FileInputStream in = new FileInputStream(file);
                XmlEtmConfigurator.configure((InputStream)in);
            }
            catch (Exception e) {
                throw new EtmConfigurationException("Error reading JETM configuration file at " + file.getAbsolutePath() + ". Cause:" + e.getMessage());
            }
        }
        InputStream in = EtmMonitor.class.getClassLoader().getResourceAsStream(fileName);
        if (in == null) throw new EtmConfigurationException("Unable to locate JETM configuration file " + fileName + " in classpath.");
        try {
            XmlEtmConfigurator.configure((InputStream)in);
        }
        catch (Exception e) {
            throw new EtmConfigurationException("Error reading JETM configuration file  " + fileName + " from classpath. Cause:" + e.getMessage());
        }
        EtmManager.getEtmMonitor().start();
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        EtmManager.getEtmMonitor().stop();
    }
}

