/*
 * Decompiled with CFR 0.152.
 */
package etm.contrib.aop.aopalliance;

import etm.contrib.aop.aopalliance.EtmMethodCallInterceptor;
import etm.contrib.aop.resources.FooService;
import etm.core.configuration.BasicEtmConfigurator;
import etm.core.configuration.EtmManager;
import etm.core.monitor.EtmMonitor;
import etm.core.renderer.MeasurementRenderer;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.Map;
import junit.framework.TestCase;
import org.aopalliance.intercept.MethodInvocation;

public class MethodCallInterceptorTest
extends TestCase {
    private int counter = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMethodCallInterceptor() throws Throwable {
        EtmManager.reset();
        BasicEtmConfigurator.configure();
        EtmMonitor monitor = EtmManager.getEtmMonitor();
        monitor.start();
        try {
            EtmMethodCallInterceptor interceptor = new EtmMethodCallInterceptor(monitor);
            interceptor.invoke((MethodInvocation)new DummyMethodInvocation());
            try {
                interceptor.invoke((MethodInvocation)new DummyMethodInvocation());
                MethodCallInterceptorTest.fail((String)"An exception should have been thrown.");
            }
            catch (Exception exception) {
                // empty catch block
            }
            monitor.render(new MeasurementRenderer(){

                public void render(Map points) {
                    TestCase.assertTrue((points.size() > 0 ? 1 : 0) != 0);
                    TestCase.assertNotNull(points.get("FooService::doFoo"));
                    TestCase.assertNotNull(points.get("FooService::doFoo [Exception]"));
                }
            });
        }
        finally {
            monitor.stop();
        }
    }

    class DummyMethodInvocation
    implements MethodInvocation {
        private FooService fooService = new FooService();

        DummyMethodInvocation() {
        }

        public Method getMethod() {
            try {
                return this.fooService.getClass().getMethod("doFoo", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e.toString());
            }
        }

        public Object[] getArguments() {
            return new Object[0];
        }

        public Object proceed() throws Throwable {
            MethodCallInterceptorTest.this.counter++;
            switch (MethodCallInterceptorTest.this.counter % 2) {
                case 0: {
                    throw new Exception("Test Exception.");
                }
                case 1: {
                    this.fooService.doFoo();
                    return null;
                }
            }
            throw new RuntimeException("Unexpected Exception");
        }

        public Object getThis() {
            return this.fooService;
        }

        public AccessibleObject getStaticPart() {
            throw new UnsupportedOperationException();
        }
    }
}

