/*
 * Decompiled with CFR 0.152.
 */
package etm.contrib.console.util;

import etm.contrib.console.ConsoleRequest;
import etm.contrib.console.ConsoleResponse;
import etm.contrib.console.util.ConsoleUtil;
import etm.contrib.util.ExecutionAggregateComparator;
import etm.core.aggregation.Aggregate;
import etm.core.renderer.MeasurementRenderer;
import etm.core.util.Version;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class ConsoleRenderer
implements MeasurementRenderer {
    protected static final String FOOTER = " <tr><td class=\"footer\" colspan=\"6\">All times in miliseconds. Measurements provided by <a href=\"http://jetm.void.fm\" target=\"_default\">JETM " + Version.getVersion() + "</a></td></tr>\n";
    protected static final String NO_RESULTS = " <tr><td colspan=\"6\">No measurement results available.</td></tr>\n";
    protected NumberFormat timeFormatter;
    protected NumberFormat numberFormatter;
    protected ExecutionAggregateComparator comparator;
    protected ConsoleRequest request;
    protected ConsoleResponse response;

    public ConsoleRenderer(ConsoleRequest aRequest, ConsoleResponse aResponse, ExecutionAggregateComparator aComparator) {
        this.request = aRequest;
        this.response = aResponse;
        this.comparator = aComparator;
        this.timeFormatter = NumberFormat.getNumberInstance();
        this.timeFormatter.setMaximumFractionDigits(3);
        this.timeFormatter.setMinimumFractionDigits(3);
        this.timeFormatter.setGroupingUsed(true);
        this.numberFormatter = NumberFormat.getNumberInstance();
        this.numberFormatter.setMaximumFractionDigits(0);
        this.numberFormatter.setMinimumFractionDigits(0);
        this.numberFormatter.setGroupingUsed(true);
    }

    protected void writeCommonHtmlHead() throws IOException {
        this.response.write("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">");
        this.response.write("<html>\n <head> \n  <title>JETM Console</title>\n  <link rel=\"stylesheet\" type=\"text/css\" href=\"style.css\"/>\n  <link rel=\"icon\" href=\"favicon.ico\" type=\"image/x-icon\"/>  <script type=\"text/javascript\">   function confirmReset(text, url) {    if (confirm('Do you really want to reset ' + text + '?')) {     window.location=url;    };   }  </script> </head>\n");
        this.response.write("<body>\n<h1>JETM Console</h1>");
    }

    protected void writeDetailHtmlHead(String point) throws IOException {
        this.writeCommonHtmlHead();
        String pointEncoded = URLEncoder.encode(point, "UTF-8");
        Date currentTime = new Date();
        this.response.write("<table class=\"noborder\">\n");
        this.response.write("  <tr class=\"noborder\">\n    <td class=\"noborder\">Application start:</td>\n    <td class=\"noborder\">" + this.request.getEtmMonitor().getMetaData().getStartTime() + "</td>\n" + "  </tr>\n" + "  <tr class=\"noborder\">\n" + "    <td class=\"noborder\">Monitoring period:</td>\n" + "    <td class=\"noborder\">" + this.request.getEtmMonitor().getMetaData().getLastResetTime() + " - " + currentTime + "</td>\n" + "  </tr>\n");
        this.response.write("  <tr class=\"noborder\">\n    <td class=\"noborder\">Point:</td>\n    <td class=\"noborder\">" + point + "</td>\n" + "  </tr>\n");
        this.response.write("  <tr class=\"noborder\">\n    <td class=\"noborder\">&nbsp;</td>\n    <td class=\"noborder\">&nbsp;</td>\n  </tr>\n");
        this.response.write("<tr class=\"noborder\">");
        this.response.write(" <td class=\"noborder\"><a href=\"#\" onclick=\"confirmReset('");
        this.response.write(point);
        this.response.write("?','");
        this.response.write(ConsoleUtil.appendParameters("reset?point=" + pointEncoded, this.request.getRequestParameters()));
        this.response.write("');\">Reset point</a></td>");
        this.response.write("<td class=\"noborder\"><a href=\"");
        this.response.write(ConsoleUtil.appendParameters("detail?point=" + pointEncoded, this.request.getRequestParameters()));
        this.response.write("\">Reload point</a>  &nbsp; \n");
        this.response.write(" <a href=\"");
        this.response.write(ConsoleUtil.appendParameters("index", this.request.getRequestParameters(), true));
        this.response.write("\">Back to overview</a></td>\n");
        this.response.write("<tr>\n</table>\n");
    }

    protected void writeHtmlHead(boolean expanded) throws IOException {
        this.writeCommonHtmlHead();
        Date currentTime = new Date();
        this.response.write("<table class=\"noborder\">\n");
        this.response.write("  <tr class=\"noborder\">\n    <td class=\"noborder\">Application start:</td>\n    <td class=\"noborder\">" + this.request.getEtmMonitor().getMetaData().getStartTime() + "</td>\n" + "  </tr>\n" + "  <tr class=\"noborder\">\n" + "    <td class=\"noborder\">Monitoring period:</td>\n" + "    <td class=\"noborder\">" + this.request.getEtmMonitor().getMetaData().getLastResetTime() + " - " + currentTime + "</td>\n" + "  </tr>\n" + "  <tr class=\"noborder\">\n" + "    <td class=\"noborder\">Monitoring status:</td>\n");
        if (this.request.getEtmMonitor().isStarted()) {
            this.response.write("    <td class=\"noborder\"><span class=\"enabled\">enabled</span></td>\n");
        } else {
            this.response.write("    <td class=\"noborder\"><span class=\"disabled\">disabled</span></td>\n");
        }
        this.response.write("  </tr>\n  <tr class=\"noborder\">\n    <td class=\"noborder\">Collecting status:</td>\n");
        if (this.request.getEtmMonitor().isCollecting()) {
            this.response.write("    <td class=\"noborder\">\n");
            this.response.write("<a href=\"");
            this.response.write(ConsoleUtil.appendParameters("stop", this.request.getRequestParameters()));
            this.response.write("\"><span class=\"enabled\">enabled</span></a></td>");
        } else {
            this.response.write("    <td class=\"noborder\">\n");
            this.response.write("<a href=\"");
            this.response.write(ConsoleUtil.appendParameters("start", this.request.getRequestParameters()));
            this.response.write("\"><span class=\"disabled\">disabled</span></a></td>");
        }
        this.response.write("  </tr>\n  <tr class=\"noborder\">\n    <td class=\"noborder\">&nbsp;</td>\n    <td class=\"noborder\">&nbsp;</td>\n  </tr>\n");
        this.response.write("  <tr class=\"noborder\">\n");
        this.response.write("    <td class=\"noborder\"><a href=\"#\" onclick=\"confirmReset('all performance results','");
        this.response.write(ConsoleUtil.appendParameters("reset", this.request.getRequestParameters()));
        this.response.write("')\">Reset monitor</a></td>");
        if (expanded) {
            this.response.write(" <td class=\"noborder\"><a href=\"");
            this.response.write(ConsoleUtil.appendParameters("collapse", this.request.getRequestParameters()));
            this.response.write("\">Collapse results</a> &nbsp; \n");
        } else {
            this.response.write(" <td class=\"noborder\"><a href=\"");
            this.response.write(ConsoleUtil.appendParameters("expand", this.request.getRequestParameters()));
            this.response.write("\">Expand results</a> &nbsp; \n");
        }
        this.response.write(" <a href=\"");
        this.response.write(ConsoleUtil.appendParameters("index", this.request.getRequestParameters()));
        this.response.write("\">Reload monitor</a></td>\n");
        this.response.write("  </tr>\n");
        this.response.write("</table>");
    }

    protected void writeTableHeader() throws IOException {
        this.response.write(" <tr>\n");
        this.response.write("  <th width=\"200\" ");
        if (1 == this.comparator.getType()) {
            if (this.comparator.isDescending()) {
                this.response.write("class=\"descending\"><a href=\"?sort=name&amp;order=asc\">Measurement Point</a>");
            } else {
                this.response.write("class=\"ascending\"><a href=\"?sort=name&amp;order=desc\">Measurement Point</a>");
            }
        } else {
            this.response.write("><a href=\"?sort=name&amp;order=asc\">Measurement Point</a>");
        }
        this.response.write("</th>\n");
        this.response.write("  <th width=\"30\" ");
        if (2 == this.comparator.getType()) {
            if (this.comparator.isDescending()) {
                this.response.write("class=\"descending\"><a href=\"?sort=executions&amp;order=asc\">#</a>");
            } else {
                this.response.write("class=\"ascending\"><a href=\"?sort=executions&amp;order=desc\">#</a>");
            }
        } else {
            this.response.write("><a href=\"?sort=executions&amp;order=desc\">#</a> ");
        }
        this.response.write("</th>\n");
        this.response.write("  <th width=\"80\" ");
        if (3 == this.comparator.getType()) {
            if (this.comparator.isDescending()) {
                this.response.write("class=\"descending\"><a href=\"?sort=average&amp;order=asc\">Average</a>");
            } else {
                this.response.write("class=\"ascending\"><a href=\"?sort=average&amp;order=desc\">Average</a>");
            }
        } else {
            this.response.write("><a href=\"?sort=average&amp;order=desc\">Average</a> ");
        }
        this.response.write("</th>\n");
        this.response.write("  <th width=\"80\" ");
        if (4 == this.comparator.getType()) {
            if (this.comparator.isDescending()) {
                this.response.write("class=\"descending\"><a href=\"?sort=min&amp;order=asc\">Min</a>");
            } else {
                this.response.write("class=\"ascending\"><a href=\"?sort=min&amp;order=desc\">Min</a>");
            }
        } else {
            this.response.write("><a href=\"?sort=min&amp;order=desc\">Min</a> ");
        }
        this.response.write("</th>\n");
        this.response.write("  <th width=\"80\"");
        if (5 == this.comparator.getType()) {
            if (this.comparator.isDescending()) {
                this.response.write("class=\"descending\"><a href=\"?sort=max&amp;order=asc\">Max</a>");
            } else {
                this.response.write("class=\"ascending\"><a href=\"?sort=max&amp;order=desc\">Max</a>");
            }
        } else {
            this.response.write("><a href=\"?sort=max&amp;order=desc\">Max</a>");
        }
        this.response.write("</th>\n");
        this.response.write("  <th width=\"80\"");
        if (6 == this.comparator.getType()) {
            if (this.comparator.isDescending()) {
                this.response.write("class=\"descending\"><a href=\"?sort=total&amp;order=asc\">Total</a>");
            } else {
                this.response.write("class=\"ascending\"><a href=\"?sort=total&amp;order=desc\">Total</a>");
            }
        } else {
            this.response.write("><a href=\"?sort=total&amp;order=desc\">Total</a> ");
        }
        this.response.write("</th>\n");
        this.response.write(" </tr>\n");
    }

    protected void writeName(Aggregate aPoint) throws IOException {
        String link = "detail?point=";
        try {
            link = link + URLEncoder.encode(aPoint.getName(), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        link = ConsoleUtil.appendParameters(link, this.request.getRequestParameters());
        this.response.write("<div class=\"parentname\" >");
        this.response.write("<a href=\"");
        this.response.write(link);
        this.response.write("\" >");
        this.response.write(this.encodeHtml(aPoint.getName()));
        this.response.write("</a></div>");
    }

    protected void writeTotals(Aggregate aPoint) throws IOException {
        this.response.write("<div class=\"parenttotal\" >");
        this.response.write(this.timeFormatter.format(aPoint.getTotal()));
        this.response.write("</div>");
    }

    protected void writeAverage(Aggregate aPoint) throws IOException {
        this.response.write("<div class=\"parenttime\" >");
        this.response.write(this.timeFormatter.format(aPoint.getAverage()));
        this.response.write("</div>");
    }

    protected void writeMin(Aggregate aPoint) throws IOException {
        this.response.write("<div class=\"parenttime\" >");
        this.response.write(this.timeFormatter.format(aPoint.getMin()));
        this.response.write("</div>");
    }

    protected void writeMax(Aggregate aPoint) throws IOException {
        this.response.write("<div class=\"parenttime\" >");
        this.response.write(this.timeFormatter.format(aPoint.getMax()));
        this.response.write("</div>");
    }

    protected void writeMeasurements(Aggregate aPoint) throws IOException {
        this.response.write("<div class=\"parentmeasurement\" >");
        this.response.write(this.numberFormatter.format(aPoint.getMeasurements()));
        this.response.write("</div>");
    }

    protected void writeName(SortedExecutionGraph aElement, int depth) throws IOException {
        if (depth > 0) {
            this.response.write("<div class=\"childname\" >");
        } else {
            this.response.write("<div class=\"parentname\" >");
        }
        this.response.write(this.encodeHtml(aElement.getName()));
        if (aElement.hasChilds()) {
            int currentDepth = depth + 1;
            Iterator iterator = aElement.getSortedChilds().iterator();
            while (iterator.hasNext()) {
                this.writeName((SortedExecutionGraph)iterator.next(), currentDepth);
            }
        }
        this.response.write("</div>");
    }

    protected void writeTotals(SortedExecutionGraph aElement, int depth) throws IOException {
        if (depth > 0) {
            this.response.write("<div class=\"childtotal\" >");
        } else {
            this.response.write("<div class=\"parenttotal\" >");
        }
        this.response.write(this.timeFormatter.format(aElement.getTotal()));
        if (aElement.hasChilds()) {
            int currentDepth = depth + 1;
            Iterator iterator = aElement.getSortedChilds().iterator();
            while (iterator.hasNext()) {
                this.writeTotals((SortedExecutionGraph)iterator.next(), currentDepth);
            }
        }
        this.response.write("</div>");
    }

    protected void writeAverage(SortedExecutionGraph aElement, int depth) throws IOException {
        if (depth > 0) {
            this.response.write("<div class=\"childtime\" >");
        } else {
            this.response.write("<div class=\"parenttime\" >");
        }
        this.response.write(this.timeFormatter.format(aElement.getAverage()));
        if (aElement.hasChilds()) {
            int currentDepth = depth + 1;
            Iterator iterator = aElement.getSortedChilds().iterator();
            while (iterator.hasNext()) {
                this.writeAverage((SortedExecutionGraph)iterator.next(), currentDepth);
            }
        }
        this.response.write("</div>");
    }

    protected void writeMin(SortedExecutionGraph aElement, int depth) throws IOException {
        if (depth > 0) {
            this.response.write("<div class=\"childtime\" >");
        } else {
            this.response.write("<div class=\"parenttime\" >");
        }
        this.response.write(this.timeFormatter.format(aElement.getMin()));
        if (aElement.hasChilds()) {
            int currentDepth = depth + 1;
            Iterator iterator = aElement.getSortedChilds().iterator();
            while (iterator.hasNext()) {
                this.writeMin((SortedExecutionGraph)iterator.next(), currentDepth);
            }
        }
        this.response.write("</div>");
    }

    protected void writeMax(SortedExecutionGraph aElement, int depth) throws IOException {
        if (depth > 0) {
            this.response.write("<div class=\"childtime\" >");
        } else {
            this.response.write("<div class=\"parenttime\" >");
        }
        this.response.write(this.timeFormatter.format(aElement.getMax()));
        if (aElement.hasChilds()) {
            int currentDepth = depth + 1;
            Iterator iterator = aElement.getSortedChilds().iterator();
            while (iterator.hasNext()) {
                this.writeMax((SortedExecutionGraph)iterator.next(), currentDepth);
            }
        }
        this.response.write("</div>");
    }

    protected void writeMeasurements(SortedExecutionGraph aElement, int depth) throws IOException {
        if (depth > 0) {
            this.response.write("<div class=\"childmeasurement\" >");
        } else {
            this.response.write("<div class=\"parentmeasurement\" >");
        }
        this.response.write(this.numberFormatter.format(aElement.getMeasurements()));
        if (aElement.hasChilds()) {
            int currentDepth = depth + 1;
            Iterator iterator = aElement.getSortedChilds().iterator();
            while (iterator.hasNext()) {
                this.writeMeasurements((SortedExecutionGraph)iterator.next(), currentDepth);
            }
        }
        this.response.write("</div>");
    }

    protected String encodeHtml(String text) {
        StringBuffer result = new StringBuffer();
        char[] chars = text.toCharArray();
        block6: for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            switch (c) {
                case '&': {
                    result.append("&amp;");
                    continue block6;
                }
                case '<': {
                    result.append("&lt;");
                    continue block6;
                }
                case '>': {
                    result.append("&gt;");
                    continue block6;
                }
                case '\"': {
                    result.append("&quot;");
                    continue block6;
                }
                default: {
                    char charAsInt = c;
                    if (charAsInt > '\u0080') {
                        result.append("&#");
                        result.append((int)charAsInt);
                        result.append(';');
                        continue block6;
                    }
                    result.append(c);
                }
            }
        }
        return result.toString();
    }

    protected class SortedExecutionGraph
    implements Aggregate {
        private Aggregate aggregate;
        private List sortedChilds;

        public SortedExecutionGraph() {
        }

        public SortedExecutionGraph(Aggregate aAggregate, ExecutionAggregateComparator aComparator) {
            this.aggregate = aAggregate;
            if (aAggregate.hasChilds()) {
                Map childs = aAggregate.getChilds();
                this.sortedChilds = new ArrayList();
                Iterator iterator = childs.values().iterator();
                while (iterator.hasNext()) {
                    SortedExecutionGraph child = new SortedExecutionGraph((Aggregate)iterator.next(), aComparator);
                    this.sortedChilds.add(child);
                }
                Collections.sort(this.sortedChilds, aComparator);
            }
        }

        public String getName() {
            return this.aggregate.getName();
        }

        public double getAverage() {
            return this.aggregate.getAverage();
        }

        public double getMin() {
            return this.aggregate.getMin();
        }

        public double getMax() {
            return this.aggregate.getMax();
        }

        public long getMeasurements() {
            return this.aggregate.getMeasurements();
        }

        public double getTotal() {
            return this.aggregate.getTotal();
        }

        public Map getChilds() {
            return this.aggregate.getChilds();
        }

        public List getSortedChilds() {
            return this.sortedChilds;
        }

        public boolean hasChilds() {
            return this.sortedChilds != null;
        }
    }
}

