/*
 * Decompiled with CFR 0.152.
 */
package etm.contrib.integration.jee.jsf;

import etm.core.configuration.EtmManager;
import etm.core.monitor.EtmPoint;
import etm.core.util.Log;
import etm.core.util.LogAdapter;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;

public class JsfPerformancePhaseListener
implements PhaseListener {
    private static final String CURRENT_PHASE_POINT = "ETM__CurrentPhasePoint";
    private static final LogAdapter LOG = Log.getLog(JsfPerformancePhaseListener.class);

    public JsfPerformancePhaseListener() {
        LOG.debug("Activated JSF phase performance monitoring.");
    }

    public void beforePhase(PhaseEvent event) {
        FacesContext facesContext = event.getFacesContext();
        EtmPoint oldPoint = (EtmPoint)facesContext.getAttributes().get(CURRENT_PHASE_POINT);
        if (oldPoint != null) {
            oldPoint.alterName(oldPoint.getName() + " - uncollected");
            oldPoint.collect();
        }
        String symbolicName = "JSF Phase " + event.getPhaseId().getOrdinal() + " - " + String.valueOf(event.getPhaseId());
        EtmPoint point = EtmManager.getEtmMonitor().createPoint(symbolicName);
        facesContext.getAttributes().put(CURRENT_PHASE_POINT, point);
    }

    public void afterPhase(PhaseEvent event) {
        FacesContext facesContext = event.getFacesContext();
        EtmPoint point = (EtmPoint)facesContext.getAttributes().get(CURRENT_PHASE_POINT);
        if (point != null) {
            point.collect();
            facesContext.getAttributes().remove(CURRENT_PHASE_POINT);
        }
    }

    public PhaseId getPhaseId() {
        return PhaseId.ANY_PHASE;
    }
}

