/*
 * Decompiled with CFR 0.152.
 */
package etm.contrib.integration.jee.jsf.wrapped;

import etm.core.configuration.EtmManager;
import etm.core.monitor.EtmPoint;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.faces.render.Renderer;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;

public class CGlibDelegatingRenderKitFactory
extends RenderKitFactory {
    private final RenderKitFactory delegate;

    public CGlibDelegatingRenderKitFactory(RenderKitFactory aDelegate) {
        this.delegate = aDelegate;
    }

    public void addRenderKit(String s, RenderKit aRenderKit) {
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(aRenderKit.getClass());
        enhancer.setCallback((Callback)new RenderKitInterceptor(aRenderKit));
        this.delegate.addRenderKit(s, (RenderKit)enhancer.create());
    }

    public RenderKit getRenderKit(FacesContext aFacesContext, String s) {
        return this.delegate.getRenderKit(aFacesContext, s);
    }

    public Iterator<String> getRenderKitIds() {
        return this.delegate.getRenderKitIds();
    }

    public RenderKitFactory getWrapped() {
        return this.delegate.getWrapped();
    }

    public class RenderEtmInterceptor
    implements MethodInterceptor {
        private Renderer target;

        public RenderEtmInterceptor(Renderer aTarget) {
            this.target = aTarget;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
            if (method.getName().equals("encodeBegin")) {
                FacesContext context = (FacesContext)args[0];
                UIComponent component = (UIComponent)args[1];
                EtmPoint point = EtmManager.getEtmMonitor().createPoint("Render " + component.getClientId());
                context.getAttributes().put("ETM__" + component.getClientId(), point);
                return method.invoke((Object)this.target, args);
            }
            if (method.getName().equals("encodeEnd")) {
                try {
                    Object object = method.invoke((Object)this.target, args);
                    return object;
                }
                finally {
                    FacesContext context = (FacesContext)args[0];
                    UIComponent component = (UIComponent)args[1];
                    EtmPoint point = (EtmPoint)context.getAttributes().get("ETM__" + component.getClientId());
                    if (point != null) {
                        point.collect();
                    }
                }
            }
            return method.invoke((Object)this.target, args);
        }
    }

    class RenderKitInterceptor
    implements MethodInterceptor {
        private RenderKit target;
        private Map<Renderer, Renderer> proxyCache = new ConcurrentHashMap<Renderer, Renderer>();

        RenderKitInterceptor(RenderKit aTarget) {
            this.target = aTarget;
        }

        public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
            if (method.getName().equals("getRenderer")) {
                Renderer renderer = (Renderer)method.invoke((Object)this.target, args);
                if (renderer == null) {
                    return null;
                }
                if (this.proxyCache.containsKey(renderer)) {
                    return this.proxyCache.get(renderer);
                }
                Renderer proxyInstance = this.createProxyIfPossible(renderer);
                this.proxyCache.put(renderer, proxyInstance);
                return proxyInstance;
            }
            return method.invoke((Object)this.target, args);
        }

        protected Renderer createProxyIfPossible(Renderer aRenderer) {
            Enhancer enhancer = new Enhancer();
            enhancer.setSuperclass(aRenderer.getClass());
            enhancer.setCallback((Callback)new RenderEtmInterceptor(aRenderer));
            return (Renderer)enhancer.create();
        }
    }
}

