/*
 * Decompiled with CFR 0.152.
 */
package etm.tutorial.fiveminute.client;

import etm.tutorial.fiveminute.store.GroceryStore;
import etm.tutorial.fiveminute.store.UnknownArticleException;
import etm.tutorial.fiveminute.store.model.Item;
import etm.tutorial.fiveminute.store.model.OrderStatus;
import etm.tutorial.fiveminute.store.model.StockItem;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.text.NumberFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class OrderClient {
    private static final String SPACES = "          ";
    private GroceryStore agent;

    public OrderClient(GroceryStore aAgent) {
        this.agent = aAgent;
    }

    public void execute() {
        boolean shouldRun = true;
        System.out.println("Welcome to the JETM Grocery Store!");
        System.out.println();
        while (shouldRun) {
            this.printCurrentStock();
            int itemId = this.readIntFromConsole();
            if (itemId > 0) {
                this.processOrder(itemId);
                continue;
            }
            if (itemId == 0) {
                shouldRun = false;
                continue;
            }
            System.out.println("Error...");
        }
    }

    protected void processOrder(int aItemId) {
        this.printPrompt("Enter Quantity: ");
        int quantity = this.readIntFromConsole();
        try {
            OrderStatus orderStatus = this.agent.buy(aItemId, quantity);
            if (orderStatus.isSuccess()) {
                System.out.println("Thank you for your order.");
            } else {
                System.out.println("Unable to purchase item " + orderStatus.getItem().getName() + " with quantity " + quantity);
            }
        }
        catch (UnknownArticleException e) {
            System.err.println("There is no item with item ID " + aItemId);
        }
        System.out.println();
    }

    protected int readIntFromConsole() {
        BufferedReader stdIn = new BufferedReader(new InputStreamReader(System.in));
        try {
            String line = stdIn.readLine();
            return Integer.parseInt(line);
        }
        catch (Exception e) {
            return -1;
        }
    }

    protected void printCurrentStock() {
        System.out.println("We currently have in stock:");
        System.out.println(" ------------------------------");
        System.out.println(" | ID | Qty | Item    | Price |");
        System.out.println(" ------------------------------");
        List list = this.agent.listStock();
        Collections.sort(list, new Comparator(){

            public int compare(Object o1, Object o2) {
                int two;
                int one = ((StockItem)o1).getItem().getId();
                return one < (two = ((StockItem)o2).getItem().getId()) ? -1 : 1;
            }
        });
        Iterator it = list.iterator();
        while (it.hasNext()) {
            StockItem stockItem = (StockItem)it.next();
            Item item = stockItem.getItem();
            System.out.print(" |  ");
            System.out.print(item.getId());
            System.out.print(" | ");
            System.out.print(this.ensureWidth(String.valueOf(stockItem.getQuantity()), 3));
            System.out.print(" | ");
            System.out.print(this.ensureWidth(item.getName(), 7));
            System.out.print(" | ");
            System.out.print(NumberFormat.getCurrencyInstance().format(item.getPrice()));
            System.out.println(" | ");
        }
        System.out.println(" ------------------------------");
        System.out.println();
        this.printPrompt("Enter item id to order (or 0 exit): ");
    }

    private String ensureWidth(String value, int i) {
        if (value.length() < i) {
            return SPACES.substring(0, i - value.length()) + value;
        }
        return value;
    }

    protected void printPrompt(String message) {
        if (System.getProperty("ant.runtime") != null) {
            System.out.println(message);
        } else {
            System.out.print(message);
        }
    }
}

