/*
 * Decompiled with CFR 0.152.
 */
package etm.tutorial.fiveminute.store;

import etm.tutorial.fiveminute.store.GroceryStore;
import etm.tutorial.fiveminute.store.UnknownArticleException;
import etm.tutorial.fiveminute.store.dao.StockDao;
import etm.tutorial.fiveminute.store.model.Item;
import etm.tutorial.fiveminute.store.model.OrderStatus;
import java.util.List;

public class GroceryStoreImpl
implements GroceryStore {
    private StockDao stockDao;
    private int orderId = 0;

    public GroceryStoreImpl(StockDao aStockDao) {
        this.stockDao = aStockDao;
    }

    public OrderStatus buy(int aItemId, int quantity) throws UnknownArticleException {
        Item orderedItem = this.stockDao.getItem(aItemId);
        if (orderedItem == null) {
            throw new UnknownArticleException();
        }
        if (this.stockDao.addOrder(orderedItem, quantity)) {
            return new OrderStatus(orderedItem, ++this.orderId);
        }
        return new OrderStatus(orderedItem);
    }

    public List listStock() {
        return this.stockDao.getCurrentStock();
    }
}

