/*
 * Decompiled with CFR 0.152.
 */
package etm.tutorial.fiveminute.store.dao;

import etm.tutorial.fiveminute.store.UnknownArticleException;
import etm.tutorial.fiveminute.store.dao.StockDao;
import etm.tutorial.fiveminute.store.model.Item;
import etm.tutorial.fiveminute.store.model.StockItem;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StockDaoImpl
implements StockDao {
    private Map catalog = new HashMap();
    private Map stock = new HashMap();

    public StockDaoImpl() {
        this.loadInitialStock();
    }

    public boolean addOrder(Item item, int quantity) throws UnknownArticleException {
        StockItem stockItem = (StockItem)this.stock.get(new Integer(item.getId()));
        if (stockItem != null) {
            if (stockItem.getQuantity() >= quantity) {
                stockItem.decreaseQuantity(quantity);
                if (stockItem.getQuantity() == 0) {
                    this.stock.remove(new Integer(stockItem.getItem().getId()));
                }
                return true;
            }
            return false;
        }
        throw new UnknownArticleException();
    }

    public List getCurrentStock() {
        return new ArrayList(this.stock.values());
    }

    public Item getItem(int aItemId) {
        return (Item)this.catalog.get(new Integer(aItemId));
    }

    private void loadInitialStock() {
        this.catalog.put(new Integer(1), new Item(1, "apples", new BigDecimal(2.99)));
        this.catalog.put(new Integer(2), new Item(2, "oranges", new BigDecimal(1.49)));
        this.catalog.put(new Integer(3), new Item(3, "bananas", new BigDecimal(1.99)));
        this.catalog.put(new Integer(4), new Item(4, "grapes", new BigDecimal(2.49)));
        this.stock.put(new Integer(1), new StockItem((Item)this.catalog.get(new Integer(1)), 15));
        this.stock.put(new Integer(2), new StockItem((Item)this.catalog.get(new Integer(2)), 5));
        this.stock.put(new Integer(3), new StockItem((Item)this.catalog.get(new Integer(3)), 20));
        this.stock.put(new Integer(4), new StockItem((Item)this.catalog.get(new Integer(4)), 11));
    }
}

