/*
 * Decompiled with CFR 0.152.
 */
package etm.contrib.aop.common;

import etm.core.configuration.BasicEtmConfigurator;
import etm.core.configuration.EtmConfigurationException;
import etm.core.configuration.EtmManager;
import etm.core.configuration.XmlEtmConfigurator;
import etm.core.monitor.EtmException;
import etm.core.util.Log;
import etm.core.util.LogAdapter;
import java.net.MalformedURLException;
import java.net.URL;

public class EtmLifecycleAspect {
    private static final LogAdapter log = Log.getLog((Class)EtmLifecycleAspect.class);
    private static final String DEFAULT_CONFIG_FILE = "jetm-config.xml";

    public void enableBasicConfig() {
        if (!EtmManager.getEtmMonitor().isStarted()) {
            BasicEtmConfigurator.configure((boolean)true);
            EtmManager.getEtmMonitor().start();
        } else {
            log.warn("Etm subsystem already initialized. Ignoring init.");
        }
    }

    public void enableXmlConfig() {
        this.enableXmlConfigByClasspathResource(DEFAULT_CONFIG_FILE);
    }

    public void enableXmlConfigByUrl(String url) {
        try {
            this.enable(new URL(url));
        }
        catch (MalformedURLException e) {
            throw new EtmException((Throwable)e);
        }
    }

    public void enableXmlConfigByClasspathResource(String classpathResource) {
        URL resource = Thread.currentThread().getContextClassLoader().getResource(classpathResource);
        if (resource == null) {
            throw new EtmException("Unable to locate default resource " + classpathResource + " in classpath.");
        }
        this.enable(resource);
    }

    public void disable() {
        EtmManager.getEtmMonitor().stop();
    }

    protected void enable(URL url) {
        if (!EtmManager.getEtmMonitor().isStarted()) {
            XmlEtmConfigurator.configure((URL)url);
            EtmManager.getEtmMonitor().start();
        } else {
            log.warn("Etm subsystem already initialized. Ignoring init.");
        }
    }

    protected String replaceBySystemProperty(String value) {
        String key;
        if (value != null && value.startsWith("${") && value.endsWith("}") && (value = System.getProperty(key = value.substring(2, value.length() - 1))) == null) {
            throw new EtmConfigurationException("Error reading value from system properties using name " + key);
        }
        return value;
    }
}

