/*
 * Decompiled with CFR 0.152.
 */
package etm.contrib.integration.cdi;

import etm.contrib.integration.cdi.Measure;
import etm.core.monitor.EtmMonitor;
import etm.core.monitor.EtmPoint;
import java.io.Serializable;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;

@Interceptor
@Measure
public class EtmInterceptor
implements Serializable {
    @Inject
    private EtmMonitor monitor;

    @AroundInvoke
    public Object measure(InvocationContext ctx) throws Exception {
        Class<?> aClass = ctx.getTarget().getClass();
        if (aClass.isSynthetic()) {
            aClass = aClass.getSuperclass();
        }
        String targetMethod = aClass.getSimpleName() + ":" + ctx.getMethod().getName();
        EtmPoint point = this.monitor.createPoint(targetMethod);
        try {
            Object object = ctx.proceed();
            return object;
        }
        catch (Exception e) {
            point.alterName(targetMethod + "[ " + e.getClass().getSimpleName() + "]");
            throw e;
        }
        finally {
            point.collect();
        }
    }
}

