/*
 * Decompiled with CFR 0.152.
 */
package etm.contrib.integration.cdi;

import etm.contrib.integration.cdi.ApplyTo;
import etm.contrib.integration.cdi.Measure;
import etm.contrib.integration.cdi.de.openknowledge.cdi.common.spi.AbstractCdiBean;
import etm.contrib.integration.cdi.de.openknowledge.cdi.common.spi.DelegatingAnnotatedMethod;
import etm.contrib.integration.cdi.de.openknowledge.cdi.common.spi.DelegatingAnnotatedType;
import etm.core.configuration.BasicEtmConfigurator;
import etm.core.configuration.EtmManager;
import etm.core.configuration.EtmMonitorConfig;
import etm.core.configuration.EtmMonitorFactory;
import etm.core.configuration.XmlConfigParser;
import etm.core.monitor.EtmException;
import etm.core.monitor.EtmMonitor;
import etm.core.util.Log;
import etm.core.util.LogAdapter;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.util.AnnotationLiteral;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QualifiedEtmExtension
implements Extension {
    private static final LogAdapter LOG = Log.getLog(EtmMonitor.class);
    private static final String DEFAULT_CONFIG_FILE = "jetm-config.xml";
    private EtmMonitorConfig monitorConfig;
    private boolean delayedAutoStart;
    private EtmMonitor etmMonitor;
    private ApplyToResolver resolver;

    public void beforeScan(@Observes BeforeBeanDiscovery event) {
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(DEFAULT_CONFIG_FILE);
        try {
            if (in != null) {
                this.monitorConfig = XmlConfigParser.extractConfig((InputStream)in);
                this.delayedAutoStart = this.monitorConfig.isAutostart();
                this.monitorConfig.setAutostart(false);
            } else {
                this.delayedAutoStart = true;
            }
        }
        catch (Exception e) {
            throw new EtmException((Throwable)e);
        }
        this.resolver = new ApplyToResolver();
    }

    public void afterScan(@Observes AfterBeanDiscovery event, BeanManager bm) {
        try {
            if (this.monitorConfig != null) {
                this.etmMonitor = EtmMonitorFactory.createEtmMonitor((EtmMonitorConfig)this.monitorConfig);
                CdiEtmManager.configure(this.etmMonitor);
            } else {
                BasicEtmConfigurator.configure((boolean)true);
                this.etmMonitor = EtmManager.getEtmMonitor();
            }
        }
        catch (Exception e) {
            event.addDefinitionError((Throwable)e);
            return;
        }
        event.addBean((Bean)new EtmMonitorBean(bm, this.etmMonitor));
    }

    public void afterDeployment(@Observes AfterDeploymentValidation event) {
        if (this.delayedAutoStart) {
            this.etmMonitor.start();
        }
    }

    public <T> void addMeasurement(@Observes ProcessAnnotatedType<T> event) {
        AnnotatedType annotatedType = event.getAnnotatedType();
        if (!annotatedType.isAnnotationPresent(Measure.class)) {
            AnnotationLiteral<Measure> annotationLiteral = new AnnotationLiteral<Measure>(){};
            if (this.resolver.isQualifiedApiType(annotatedType)) {
                LOG.debug("Adding public API performance monitoring to " + annotatedType.getJavaClass());
                event.setAnnotatedType(new DelegatingAnnotatedType(annotatedType, new Annotation[]{annotationLiteral}));
            } else if (this.resolver.isQualifiedMethodType(annotatedType)) {
                LOG.debug("Adding public method performance monitoring to " + annotatedType.getJavaClass());
                event.setAnnotatedType(new PublicMethodApplyToDelegatingAnnotatedType(annotatedType));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PublicMethodApplyToDelegatingAnnotatedType<T>
    extends DelegatingAnnotatedType<T> {
        private boolean initalized = false;
        private Measure classLevelMeasurementAttribute;

        public PublicMethodApplyToDelegatingAnnotatedType(AnnotatedType<T> delegateType) {
            super(delegateType, new Annotation[0]);
        }

        @Override
        protected AnnotatedMethod<? super T> processAnnotatedMethod(AnnotatedMethod<? super T> method) {
            String name = method.getJavaMember().getName();
            if (!(this.getClassLevelMeasurementAttribute() != null || name.startsWith("get") || name.startsWith("set") || name.startsWith("is") || method.isAnnotationPresent(Measure.class))) {
                LOG.debug("Public Method Monitoring enabled for " + method.getJavaMember());
                return new DelegatingAnnotatedMethod<T>(this, method, new Annotation[]{new AnnotationLiteral<Measure>(){}});
            }
            return method;
        }

        public Measure getClassLevelMeasurementAttribute() {
            if (!this.initalized) {
                this.init();
            }
            return this.classLevelMeasurementAttribute;
        }

        private void init() {
            this.classLevelMeasurementAttribute = (Measure)this.getDelegate().getAnnotation(Measure.class);
            this.initalized = true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ApplyToResolver {
        private Map<String, ApplyTo> cache = new HashMap<String, ApplyTo>();

        ApplyToResolver() {
            Package[] packages;
            for (Package pkg : packages = Package.getPackages()) {
                this.registerApplyToIfAppropriate(pkg.getName(), pkg.getAnnotation(ApplyTo.class));
            }
        }

        protected <T> boolean isQualifiedApiType(AnnotatedType<T> type) {
            ApplyTo applyTo = this.findApplyTo(type.getJavaClass().getPackage().getName());
            if (applyTo != null) {
                for (Class<? extends Annotation> t : applyTo.qualifiedApi()) {
                    if (!type.isAnnotationPresent(t)) continue;
                    return true;
                }
            }
            return false;
        }

        protected <T> boolean isQualifiedMethodType(AnnotatedType<T> type) {
            ApplyTo applyTo = this.findApplyTo(type.getJavaClass().getPackage().getName());
            if (applyTo != null) {
                for (Class<? extends Annotation> t : applyTo.qualifiedMethod()) {
                    if (!type.isAnnotationPresent(t)) continue;
                    return true;
                }
            }
            return false;
        }

        protected <T> ApplyTo findApplyTo(String packageName) {
            while (packageName != null) {
                ApplyTo applyTo = this.cache.get(packageName);
                if (applyTo != null) {
                    return applyTo;
                }
                try {
                    Class<?> aClass = Class.forName(packageName + ".package-info");
                    ApplyTo annotation = aClass.getAnnotation(ApplyTo.class);
                    this.registerApplyToIfAppropriate(packageName, annotation);
                    if (annotation != null) {
                        return annotation;
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                packageName = this.getParentPackage(packageName);
            }
            return null;
        }

        protected boolean registerApplyToIfAppropriate(String packageName, ApplyTo annotation) {
            if (annotation != null) {
                Package[] packages;
                LOG.info("Using " + annotation + " for " + packageName + " and above.");
                this.cache.put(packageName, annotation);
                for (Package pkg : packages = Package.getPackages()) {
                    String name = pkg.getName();
                    if (name.equals(packageName) || !name.startsWith(packageName) || this.cache.containsKey(name)) continue;
                    if (pkg.isAnnotationPresent(ApplyTo.class)) {
                        this.registerApplyToIfAppropriate(name, pkg.getAnnotation(ApplyTo.class));
                        continue;
                    }
                    this.cache.put(name, annotation);
                }
                return true;
            }
            return false;
        }

        protected String getParentPackage(String aPackage) {
            int i = aPackage.lastIndexOf(46);
            if (i >= 0) {
                return aPackage.substring(0, i);
            }
            return null;
        }
    }

    static class CdiEtmManager
    extends EtmManager {
        CdiEtmManager() {
        }

        protected static void configure(EtmMonitor aEtmMonitor) {
            EtmManager.configure((EtmMonitor)aEtmMonitor);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class EtmMonitorBean
    extends AbstractCdiBean<EtmMonitor> {
        private EtmMonitor etmMonitor;

        public EtmMonitorBean(BeanManager beanManager, EtmMonitor aEtmMonitor) {
            super(null, EtmMonitor.class, beanManager, new Annotation[0]);
            this.etmMonitor = aEtmMonitor;
        }

        public EtmMonitor create(CreationalContext<EtmMonitor> context) {
            return this.etmMonitor;
        }

        public void destroy(EtmMonitor instance, CreationalContext<EtmMonitor> context) {
            instance.stop();
        }

        @Override
        public Class<? extends Annotation> getScope() {
            return ApplicationScoped.class;
        }
    }
}

