/*
 * Decompiled with CFR 0.152.
 */
package etm.contrib.console.util;

import etm.core.monitor.EtmException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ConsoleUtil {
    public static String appendParameters(String url, Map parameters) {
        return ConsoleUtil.appendParameters(url, parameters, false);
    }

    public static String appendParameters(String url, Map parameters, boolean removeDetails) {
        StringBuffer result = new StringBuffer(url);
        try {
            if (parameters != null && parameters.size() > 0) {
                if (url.indexOf(63) < 0) {
                    result.append("?");
                } else {
                    result.append("&amp;");
                }
                Iterator iterator = parameters.keySet().iterator();
                while (iterator.hasNext()) {
                    String name = (String)iterator.next();
                    if (removeDetails && "point".equals(name)) continue;
                    result.append(URLEncoder.encode(name, "UTF-8"));
                    result.append("=");
                    result.append(URLEncoder.encode((String)parameters.get(name), "UTF-8"));
                    result.append("&amp;");
                }
                if (url.endsWith("&amp;")) {
                    result.delete(url.length() - 5, 5);
                }
            }
            return result.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new EtmException((Throwable)e);
        }
    }

    public static Map extractRequestParameters(byte[] aTemp, int parameterStart, int endOfLine) {
        try {
            int index;
            HashMap map = new HashMap();
            int lastEnd = parameterStart;
            int currentDelimiter = parameterStart;
            block6: for (index = parameterStart; index < endOfLine; ++index) {
                switch (aTemp[index]) {
                    case 61: {
                        currentDelimiter = index;
                        continue block6;
                    }
                    case 38: {
                        ConsoleUtil.parseParameters(map, aTemp, index, lastEnd, currentDelimiter);
                        currentDelimiter = index;
                        lastEnd = index;
                        continue block6;
                    }
                }
            }
            ConsoleUtil.parseParameters(map, aTemp, index, lastEnd, currentDelimiter);
            return map;
        }
        catch (UnsupportedEncodingException e) {
            throw new EtmException((Throwable)e);
        }
    }

    private static void parseParameters(Map aMap, byte[] aTemp, int aIndex, int aLastEnd, int aCurrentDelimiter) throws UnsupportedEncodingException {
        if (aCurrentDelimiter <= aLastEnd) {
            String key = new String(aTemp, aLastEnd + 1, aIndex - aLastEnd - 1, "UTF-8");
            try {
                aMap.put(URLDecoder.decode(key, "UTF-8"), "");
            }
            catch (UnsupportedEncodingException e) {}
        } else {
            try {
                String key = new String(aTemp, aLastEnd + 1, aCurrentDelimiter - aLastEnd - 1, "UTF-8");
                String value = new String(aTemp, aCurrentDelimiter + 1, aIndex - aCurrentDelimiter - 1, "UTF-8").trim();
                aMap.put(URLDecoder.decode(key, "UTF-8"), URLDecoder.decode(value, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
        }
    }
}

