/*
 * Decompiled with CFR 0.152.
 */
package etm.contrib.rrd.rrd4j;

import etm.contrib.rrd.rrd4j.Rrd4jUtil;
import java.io.File;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import junit.framework.TestCase;
import org.rrd4j.core.RrdDb;
import org.rrd4j.core.Util;

public class Rrd4jUtilTest
extends TestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateDb() throws Exception {
        URL resource = Thread.currentThread().getContextClassLoader().getResource("etm/contrib/rrd/rrd4j/resources/basic_db_template.xml");
        File path = File.createTempFile("test", ".rrd");
        try {
            path.delete();
            Rrd4jUtil rrd4jUtil = new Rrd4jUtil();
            rrd4jUtil.createRrdDb(resource, path, null);
            Rrd4jUtilTest.assertTrue((boolean)path.exists());
            RrdDb db = new RrdDb(path.getAbsolutePath(), true);
            Rrd4jUtilTest.assertEquals((int)4, (int)db.getDsCount());
            db.close();
        }
        finally {
            if (path.exists()) {
                path.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateImage() throws Exception {
        URL dbResource = Thread.currentThread().getContextClassLoader().getResource("etm/contrib/rrd/rrd4j/resources/basic_db_template.xml");
        URL imageResource = Thread.currentThread().getContextClassLoader().getResource("etm/contrib/rrd/rrd4j/template/graph/average-and-tx-template.xml");
        File dbPath = File.createTempFile("test", ".rrd");
        File imagePath = File.createTempFile("test", ".png");
        try {
            dbPath.delete();
            imagePath.delete();
            Rrd4jUtil rrd4jUtil = new Rrd4jUtil();
            rrd4jUtil.createRrdDb(dbResource, dbPath, null);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("imagetitle", "test image");
            long intervalend = Util.getTimestamp((Date)new Date());
            long intervalstart = intervalend - 3600L;
            rrd4jUtil.createGraph(imageResource, dbPath, imagePath, intervalstart, intervalend, map);
            Rrd4jUtilTest.assertTrue((boolean)imagePath.exists());
        }
        finally {
            if (imagePath.exists()) {
                imagePath.delete();
            }
            if (dbPath.exists()) {
                dbPath.delete();
            }
        }
    }
}

