/*
 * Decompiled with CFR 0.152.
 */
package etm.contrib.integration.spring.configuration;

import etm.core.util.Log;
import etm.core.util.LogAdapter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public abstract class JetmBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    private static final LogAdapter LOG = Log.getLog((Class)JetmBeanDefinitionParser.class);

    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
        String id = super.resolveId(element, definition, parserContext);
        if (id == null || id.length() == 0) {
            return this.generateName(definition, parserContext);
        }
        return id;
    }

    protected String generateName(AbstractBeanDefinition definition, ParserContext parserContext) {
        Method method = this.getGenerateBeanNameMethod();
        try {
            Object[] parameters = this.getMethodParameters(definition, parserContext);
            Object beanName = method.invoke((Object)null, parameters);
            return beanName.toString();
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("Unable to invoke spring method via reflection.", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Unable to invoke spring method via reflection.", e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException("Unable to invoke spring method via reflection.", e);
        }
    }

    private Object[] getMethodParameters(AbstractBeanDefinition definition, ParserContext parserContext) {
        Object[] parameters = new Object[]{definition, parserContext.getRegistry(), parserContext.isNested()};
        return parameters;
    }

    private Method getGenerateBeanNameMethod() {
        try {
            return this.getGenerateBeanNameMethodSinceSpring25();
        }
        catch (NoSuchMethodException e1) {
            try {
                return this.getGenerateBeanNameMethodSinceSpring11();
            }
            catch (NoSuchMethodException e2) {
                throw new IllegalStateException("BeanDefinitionReaderUtils.generateBeanName() method not found in neither Spring < 2.5 nor Spring >= 2.5 .", e2);
            }
        }
    }

    private Method getGenerateBeanNameMethodSinceSpring11() throws NoSuchMethodException {
        LOG.debug("Using BeanDefinitionReaderUtils.generateBeanName() method for spring < 2.5 and >= 1.1");
        return BeanDefinitionReaderUtils.class.getMethod("generateBeanName", AbstractBeanDefinition.class, BeanDefinitionRegistry.class, Boolean.TYPE);
    }

    private Method getGenerateBeanNameMethodSinceSpring25() throws NoSuchMethodException {
        LOG.debug("Using BeanDefinitionReaderUtils.generateBeanName() method for spring >= 2.5");
        return BeanDefinitionReaderUtils.class.getMethod("generateBeanName", BeanDefinition.class, BeanDefinitionRegistry.class, Boolean.TYPE);
    }
}

