/*
 * Decompiled with CFR 0.152.
 */
package etm.contrib.renderer.swing;

import etm.contrib.renderer.swing.EtmPanelPane;
import etm.contrib.renderer.swing.tree.AggregationNode;
import etm.contrib.renderer.swing.tree.EtmResultTree;
import etm.contrib.renderer.swing.tree.EtmTreeModel;
import etm.core.metadata.PluginMetaData;
import etm.core.monitor.EtmMonitor;
import etm.core.monitor.EtmMonitorContext;
import etm.core.monitor.event.AggregationFinishedEvent;
import etm.core.monitor.event.AggregationListener;
import etm.core.monitor.event.AggregationStateListener;
import etm.core.monitor.event.AggregationStateLoadedEvent;
import etm.core.monitor.event.MonitorResetEvent;
import etm.core.monitor.event.PreMonitorResetEvent;
import etm.core.monitor.event.PreRootResetEvent;
import etm.core.monitor.event.RootCreateEvent;
import etm.core.monitor.event.RootResetEvent;
import etm.core.plugin.EtmPlugin;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;

public class PerformancePanel
extends EtmPanelPane {
    private EtmMonitor etmMonitor;
    protected JTree performanceGraph;
    protected EtmTreeModel model;
    private Timer timer;

    public PerformancePanel(EtmMonitor aEtmMonitor) {
        this.etmMonitor = aEtmMonitor;
        this.model = new EtmTreeModel(new DefaultMutableTreeNode());
        this.performanceGraph = new EtmResultTree(this.model);
        this.setLayout(new BorderLayout());
        this.add((Component)this.performanceGraph, "Center");
        this.etmMonitor.addPlugin((EtmPlugin)new EtmEventHandler());
        this.timer = new Timer(5000, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        (this).PerformancePanel.this.model.synchronizeToEtmState();
                        (this).PerformancePanel.this.performanceGraph.repaint();
                    }
                });
            }
        });
        this.timer.start();
    }

    class EtmEventHandler
    implements AggregationListener,
    AggregationStateListener,
    EtmPlugin {
        EtmEventHandler() {
        }

        public PluginMetaData getPluginMetaData() {
            return null;
        }

        public void init(EtmMonitorContext ctx) {
        }

        public void start() {
        }

        public void stop() {
        }

        public void onRootCreate(RootCreateEvent event) {
            AggregationNode child = new AggregationNode(event.getAggregate());
            PerformancePanel.this.model.insertNodeInto(child, (MutableTreeNode)PerformancePanel.this.model.getRoot(), ((MutableTreeNode)PerformancePanel.this.model.getRoot()).getChildCount());
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ((EtmEventHandler)EtmEventHandler.this).PerformancePanel.this.model.reload((MutableTreeNode)((EtmEventHandler)EtmEventHandler.this).PerformancePanel.this.model.getRoot());
                }
            });
        }

        public void onRootReset(RootResetEvent event) {
        }

        public void onStateLoaded(AggregationStateLoadedEvent event) {
        }

        public void onAggregationFinished(AggregationFinishedEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ((EtmEventHandler)EtmEventHandler.this).PerformancePanel.this.model.synchronizeToEtmState();
                    ((EtmEventHandler)EtmEventHandler.this).PerformancePanel.this.performanceGraph.validate();
                    ((EtmEventHandler)EtmEventHandler.this).PerformancePanel.this.performanceGraph.repaint();
                }
            });
        }

        public void onStateReset(MonitorResetEvent event) {
        }

        public void preRootReset(PreRootResetEvent event) {
        }

        public void preStateReset(PreMonitorResetEvent event) {
        }
    }
}

