/*
 * Decompiled with CFR 0.152.
 */
package de.openknowledge.cdi.job;

import de.openknowledge.cdi.common.property.Property;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.core.QuartzScheduler;
import org.quartz.core.QuartzSchedulerResources;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.spi.JobFactory;

@ApplicationScoped
public class CdiSchedulerFactory
extends StdSchedulerFactory {
    private static final Log LOG = LogFactory.getLog(CdiSchedulerFactory.class);
    @Inject
    private JobFactory jobFactory;
    @Inject
    @Property(name="org.quartz.*", mask=true)
    private Properties properties;

    @Produces
    @ApplicationScoped
    public Scheduler createScheduler() {
        try {
            Scheduler scheduler = super.getScheduler();
            scheduler.start();
            LOG.debug((Object)("Providing scheduler " + scheduler));
            return scheduler;
        }
        catch (SchedulerException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void destroyScheduler(@Disposes Scheduler aScheduler) {
        try {
            LOG.debug((Object)("Closing scheduler " + aScheduler));
            aScheduler.shutdown(true);
        }
        catch (SchedulerException e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected Scheduler instantiate(QuartzSchedulerResources resources, QuartzScheduler scheduler) {
        try {
            scheduler.setJobFactory(this.jobFactory);
            return super.instantiate(resources, scheduler);
        }
        catch (SchedulerException e) {
            throw new IllegalStateException(e);
        }
    }

    @PostConstruct
    protected void init() {
        if (this.properties != null && this.properties.size() > 0) {
            try {
                this.initialize(this.properties);
            }
            catch (SchedulerException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }
}

