/*
 * Decompiled with CFR 0.152.
 */
package de.openknowledge.cdi.scope;

import de.openknowledge.cdi.scope.AbstractContext;
import de.openknowledge.cdi.scope.DestroyableContext;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Singleton;

@Singleton
public class DefaultDestroyableContext
extends AbstractContext
implements DestroyableContext {
    private Bean<?> parentBean;
    private Class<? extends Annotation> scope;
    private BeanManager beanManager;
    private Map<Object, Map<Contextual<?>, AbstractContext.Instance<?>>> instances = new HashMap();

    public DefaultDestroyableContext(Bean<?> parentBean, Class<? extends Annotation> scope, BeanManager beanManager) {
        if (parentBean == null) {
            throw new IllegalArgumentException("bean may not be null");
        }
        if (scope == null) {
            throw new IllegalArgumentException("scope may not be null");
        }
        if (beanManager == null) {
            throw new IllegalArgumentException("beanManager may not be null");
        }
        this.parentBean = parentBean;
        this.scope = scope;
        this.beanManager = beanManager;
    }

    public Class<? extends Annotation> getScope() {
        return this.scope;
    }

    public boolean isActive() {
        return this.getParentBeanInstance(null) != null;
    }

    @Override
    public void destroy(Object destroyingBeanInstance) {
        Map<Contextual<?>, AbstractContext.Instance<?>> instances = this.instances.get(destroyingBeanInstance);
        if (instances == null) {
            return;
        }
        for (AbstractContext.Instance<?> instance : instances.values()) {
            instance.destroy();
        }
        this.instances.remove(destroyingBeanInstance);
    }

    @Override
    protected Map<Contextual<?>, AbstractContext.Instance<?>> getContextualMap(CreationalContext<?> creationalContext) {
        Object parentBeanInstance = this.getParentBeanInstance(creationalContext);
        if (parentBeanInstance == null) {
            return null;
        }
        Map<Contextual<?>, AbstractContext.Instance<?>> instances = this.instances.get(parentBeanInstance);
        if (instances == null) {
            instances = new HashMap();
            this.instances.put(parentBeanInstance, instances);
        }
        return instances;
    }

    private <T> T getParentBeanInstance(CreationalContext<T> creationalContext) {
        Context outerContext;
        Object destroyingBeanInstance;
        if (creationalContext == null && this.parentBean.getScope().equals(Dependent.class)) {
            creationalContext = this.beanManager.createCreationalContext(this.getDestroyingBean());
        }
        if ((destroyingBeanInstance = (outerContext = this.beanManager.getContext(this.parentBean.getScope())).get(this.getDestroyingBean())) == null && creationalContext != null) {
            destroyingBeanInstance = outerContext.get(this.getDestroyingBean(), creationalContext);
        }
        return (T)destroyingBeanInstance;
    }

    private <T> Bean<T> getDestroyingBean() {
        return this.parentBean;
    }
}

