/*
 * Decompiled with CFR 0.152.
 */
package de.openknowledge.cdi.scope;

import de.openknowledge.cdi.common.spi.CorrespondingLiteral;
import de.openknowledge.cdi.scope.DestroyableContext;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.interceptor.InvocationContext;

public abstract class AbstractScopeInterceptor<A extends Annotation>
implements Serializable {
    @Inject
    @Any
    private Instance<DestroyableContext> destroyableContexts;
    private Class<A> annotationType;

    protected AbstractScopeInterceptor() {
        Type actualType = this.getParameterizedType();
        this.annotationType = this.getActualClass(actualType);
    }

    private Class<A> getActualClass(Type actualType) {
        if (!(actualType instanceof Class)) {
            throw new IllegalStateException("Generic type argument of " + AbstractScopeInterceptor.class.getName() + " must be actual class");
        }
        return (Class)actualType;
    }

    private Type getParameterizedType() {
        Type abstractScopeInterceptorType = this.getAbstractScopeInterceptorType();
        if (!(abstractScopeInterceptorType instanceof ParameterizedType)) {
            throw new IllegalStateException(AbstractScopeInterceptor.class + " must be instantiated with generic type argument");
        }
        Type actualType = ((ParameterizedType)abstractScopeInterceptorType).getActualTypeArguments()[0];
        return actualType;
    }

    private Type getAbstractScopeInterceptorType() {
        return this.getAbstractScopeInterceptorType(this.getClass());
    }

    private Type getAbstractScopeInterceptorType(Class<?> superClass) {
        if (AbstractScopeInterceptor.class.equals(superClass.getSuperclass())) {
            return superClass.getGenericSuperclass();
        }
        throw new IllegalStateException(AbstractScopeInterceptor.class.getName() + " not found in type-hierarchy");
    }

    protected void destroyContexts(InvocationContext context) {
        for (Class<Annotation> scope : this.getScopes(context)) {
            DestroyableContext destroyableContext = (DestroyableContext)this.destroyableContexts.select(new Annotation[]{new CorrespondingLiteral(scope)}).get();
            destroyableContext.destroy(context.getTarget());
        }
    }

    protected Set<Class<? extends Annotation>> getScopes(InvocationContext context) {
        HashSet<Class<? extends Annotation>> scopes = new HashSet<Class<? extends Annotation>>();
        if (context.getMethod() != null) {
            scopes.addAll(this.getScopes(context.getMethod()));
        } else {
            for (Method method : context.getTarget().getClass().getMethods()) {
                scopes.addAll(this.getScopes(method));
            }
        }
        if (context.getTarget() != null) {
            scopes.addAll(this.getScopes(context.getTarget().getClass()));
        }
        if (scopes.isEmpty()) {
            throw new IllegalStateException(this.annotationType.getName() + " annotation not found");
        }
        return scopes;
    }

    protected Set<Class<? extends Annotation>> getScopes(Method method) {
        A annotation = method.getAnnotation(this.annotationType);
        return annotation != null ? new HashSet<Class<Annotation>>(this.getValue(annotation)) : Collections.emptySet();
    }

    protected Set<Class<? extends Annotation>> getScopes(Class<?> targetClass) {
        if (targetClass == null) {
            return Collections.emptySet();
        }
        A annotation = targetClass.getAnnotation(this.annotationType);
        if (annotation != null) {
            return new HashSet<Class<? extends Annotation>>(this.getValue(annotation));
        }
        return this.getScopes(targetClass.getSuperclass());
    }

    protected abstract List<Class<? extends Annotation>> getValue(A var1);
}

