/*
 * Decompiled with CFR 0.152.
 */
package etm.demo.webapp.javaee.web.registration;

import etm.demo.webapp.javaee.domain.user.NonUniqueUserNameException;
import etm.demo.webapp.javaee.domain.user.UserManagementService;
import etm.demo.webapp.javaee.web.core.Outcome;
import javax.enterprise.context.RequestScoped;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.inject.Inject;
import javax.inject.Named;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Named
@RequestScoped
public class RegistrationBean {
    @Inject
    private UserManagementService service;
    private String firstName;
    private String lastName;
    private String email;
    private String userName;
    private String password;
    private String passwordRepeat;

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String aEmail) {
        this.email = aEmail;
    }

    @NotNull
    @Size(min=1)
    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String aFirstName) {
        this.firstName = aFirstName;
    }

    @NotNull
    @Size(min=1)
    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String aLastName) {
        this.lastName = aLastName;
    }

    @NotNull
    @Size(min=1, max=15)
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String aPassword) {
        this.password = aPassword;
    }

    @NotNull
    @Size(min=1, max=15)
    public String getPasswordRepeat() {
        return this.passwordRepeat;
    }

    public void setPasswordRepeat(String aPasswordRepeat) {
        this.passwordRepeat = aPasswordRepeat;
    }

    @NotNull
    @Size(min=2, max=15)
    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String aUserName) {
        this.userName = aUserName;
    }

    public Outcome register() {
        try {
            this.service.create(this.firstName, this.lastName, this.userName, this.password, this.email);
        }
        catch (NonUniqueUserNameException e) {
            FacesContext.getCurrentInstance().addMessage("registration:username", new FacesMessage("Username " + this.userName + " already registered."));
            return null;
        }
        return Outcome.SUCCESS;
    }
}

