/*
 * Decompiled with CFR 0.152.
 */
package etm.contrib.integration.cdi.common.spi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.spi.Annotated;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegatingAnnotated {
    private Annotated delegate;
    private Map<Class<? extends Annotation>, Annotation> additionalAnnotations;
    private Map<Class<? extends Annotation>, Annotation> removedAnnotations = new HashMap<Class<? extends Annotation>, Annotation>();

    public DelegatingAnnotated(Annotated annotated, Annotation ... annotationsToAdd) {
        this.delegate = annotated;
        this.additionalAnnotations = new HashMap<Class<? extends Annotation>, Annotation>();
        for (Annotation annotation : annotationsToAdd) {
            this.addAnnotation(annotation);
        }
    }

    public Annotated getDelegate() {
        return this.delegate;
    }

    public Type getBaseType() {
        return this.delegate.getBaseType();
    }

    public Set<Type> getTypeClosure() {
        return this.delegate.getTypeClosure();
    }

    public Set<Annotation> getAnnotations() {
        HashSet<Annotation> annotations = new HashSet<Annotation>(this.delegate.getAnnotations());
        annotations.removeAll(this.removedAnnotations.values());
        annotations.addAll(this.additionalAnnotations.values());
        return annotations;
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
        if (this.additionalAnnotations.containsKey(annotationType)) {
            return (T)this.additionalAnnotations.get(annotationType);
        }
        if (!this.removedAnnotations.containsKey(annotationType)) {
            return (T)this.delegate.getAnnotation(annotationType);
        }
        return null;
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        return this.additionalAnnotations.containsKey(annotationType) || this.delegate.isAnnotationPresent(annotationType) && !this.removedAnnotations.containsKey(annotationType);
    }

    public void removeAnnotation(Class<? extends Annotation> annotationType) {
        Annotation annotation = this.delegate.getAnnotation(annotationType);
        if (annotation != null) {
            this.removedAnnotations.put(annotation.annotationType(), annotation);
        }
    }

    public void addAnnotation(Annotation annotation) {
        this.additionalAnnotations.put(annotation.annotationType(), annotation);
    }
}

