/*
 * Decompiled with CFR 0.152.
 */
package etm.contrib.console.standalone;

import etm.contrib.console.ConsoleResponse;
import etm.contrib.console.util.ConsoleUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;

public class StandaloneConsoleResponse
implements ConsoleResponse {
    protected static final byte[] LINEFEED = new byte[]{13, 10};
    private static final byte[] SERVER_HEADER = "Server: JETM console\r\n".getBytes(Charset.defaultCharset());
    private static final String RFC1123_PATTERN = "EEE, dd MMM yyyy HH:mm:ss zzz";
    private Map headers;
    private Writer bufferWriter;
    private ByteArrayOutputStream bufferOutStream;
    private String redirectUrl;
    private HttpStatus status;
    private OutputStream destination;

    public StandaloneConsoleResponse(OutputStream aDestination) {
        try {
            this.headers = new HashMap();
            this.bufferOutStream = new ByteArrayOutputStream();
            this.bufferWriter = new OutputStreamWriter((OutputStream)this.bufferOutStream, "UTF-8");
            this.destination = aDestination;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    public void addHeader(String header, String value) {
        this.headers.put(header, value);
    }

    public void write(String content) throws IOException {
        this.bufferWriter.write(content);
    }

    public void write(char[] content) throws IOException {
        this.bufferWriter.write(content);
    }

    public void write(byte[] content) throws IOException {
        this.bufferOutStream.write(content);
    }

    public void sendRedirect(String target, Map parameters) {
        this.redirectUrl = ConsoleUtil.appendParameters(target, parameters);
    }

    public void sendStatus(int statusCode, String description) {
        this.status = new HttpStatus(statusCode, description);
    }

    public void flush() throws IOException {
        if (this.status != null) {
            this.writeStatus();
        } else if (this.redirectUrl != null) {
            this.writeRedirect();
        } else {
            this.writeContent();
        }
        this.destination.flush();
    }

    private void writeStatus() throws IOException {
        this.destination.write("HTTP/1.0 ".getBytes("UTF-8"));
        this.destination.write(String.valueOf(this.status.statusCode).getBytes("UTF-8"));
        this.destination.write(32);
        this.destination.write(this.status.description.getBytes("UTF-8"));
        this.destination.write(LINEFEED);
        this.destination.write(SERVER_HEADER);
        this.destination.write(("Date: " + this.getRfc1123Date()).getBytes("UTF-8"));
        this.destination.write(LINEFEED);
        this.destination.write("Connection: close".getBytes("UTF-8"));
        this.destination.write(LINEFEED);
        this.destination.write(LINEFEED);
    }

    private void writeRedirect() throws IOException {
        this.destination.write("HTTP/1.0 302 OK".getBytes("UTF-8"));
        this.destination.write(LINEFEED);
        this.destination.write(SERVER_HEADER);
        this.destination.write(("Date: " + this.getRfc1123Date()).getBytes("UTF-8"));
        this.destination.write(LINEFEED);
        this.destination.write("Location: ".getBytes("UTF-8"));
        this.destination.write(this.redirectUrl.getBytes("UTF-8"));
        this.destination.write(LINEFEED);
        this.destination.write("Connection: close".getBytes("UTF-8"));
        this.destination.write(LINEFEED);
        this.destination.write(LINEFEED);
    }

    private void writeContent() throws IOException {
        this.bufferWriter.flush();
        this.destination.write("HTTP/1.0 200 OK".getBytes("UTF-8"));
        this.destination.write(LINEFEED);
        this.destination.write(SERVER_HEADER);
        this.destination.write(("Date: " + this.getRfc1123Date()).getBytes("UTF-8"));
        this.destination.write(LINEFEED);
        for (String name : this.headers.keySet()) {
            this.destination.write(name.getBytes("UTF-8"));
            this.destination.write(": ".getBytes("UTF-8"));
            this.destination.write(((String)this.headers.get(name)).getBytes("UTF-8"));
            this.destination.write(LINEFEED);
        }
        this.destination.write(("Content-Length: " + this.bufferOutStream.size()).getBytes("UTF-8"));
        this.destination.write(LINEFEED);
        this.destination.write("Connection: close".getBytes("UTF-8"));
        this.destination.write(LINEFEED);
        this.destination.write(LINEFEED);
        this.destination.write(this.bufferOutStream.toByteArray());
    }

    private String getRfc1123Date() {
        SimpleDateFormat dateFormat = new SimpleDateFormat(RFC1123_PATTERN);
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return dateFormat.format(new Date());
    }

    static class HttpStatus {
        private int statusCode;
        private String description;

        public HttpStatus(int aStatusCode, String aDescription) {
            this.statusCode = aStatusCode;
            this.description = aDescription;
        }
    }
}

