/*
 * Decompiled with CFR 0.152.
 */
package etm.contrib.console.util;

import etm.contrib.console.ConsoleRequest;
import etm.contrib.console.ConsoleResponse;
import etm.contrib.console.util.ConsoleRenderer;
import etm.contrib.util.ExecutionAggregateComparator;
import etm.core.aggregation.Aggregate;
import etm.core.monitor.EtmException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;

public class ExpandedResultRenderer
extends ConsoleRenderer {
    public ExpandedResultRenderer(ConsoleRequest aRequest, ConsoleResponse aResponse, ExecutionAggregateComparator aComparator) {
        super(aRequest, aResponse, aComparator);
    }

    public void render(Map points) {
        Object[] values = points.values().toArray();
        try {
            this.writeHtmlHead(true);
            this.response.write("<table>\n");
            this.writeTableHeader();
            if (points.isEmpty()) {
                this.response.write(" <tr><td colspan=\"6\">No measurement results available.</td></tr>\n");
            } else {
                Arrays.sort(values, this.comparator);
                for (int i = 0; i < values.length; ++i) {
                    ConsoleRenderer.SortedExecutionGraph graphSorted = new ConsoleRenderer.SortedExecutionGraph((Aggregate)values[i], this.comparator);
                    this.response.write(" <tr>\n");
                    this.response.write("  <td>");
                    this.writeName(graphSorted, 0);
                    this.response.write("</td>\n");
                    this.response.write("  <td>");
                    this.writeMeasurements(graphSorted, 0);
                    this.response.write("</td>\n");
                    this.response.write("  <td>");
                    this.writeAverage(graphSorted, 0);
                    this.response.write("</td>\n");
                    this.response.write("  <td>");
                    this.writeMin(graphSorted, 0);
                    this.response.write("</td>\n");
                    this.response.write("  <td>");
                    this.writeMax(graphSorted, 0);
                    this.response.write("</td>\n");
                    this.response.write("  <td>");
                    this.writeTotals(graphSorted, 0);
                    this.response.write("</td>\n");
                    this.response.write(" </tr>\n");
                }
            }
            this.response.write(FOOTER);
            this.response.write("</table>\n");
            this.response.write(" </body>\n</html>");
        }
        catch (IOException e) {
            throw new EtmException("Unable to write to writer: " + e);
        }
    }
}

