/*
 * Decompiled with CFR 0.152.
 */
package etm.contrib.integration.web;

import etm.contrib.console.ConsoleAction;
import etm.contrib.console.actions.ActionRegistry;
import etm.contrib.console.servlet.ServletConsoleRequest;
import etm.contrib.console.servlet.ServletConsoleResponse;
import etm.contrib.console.util.ResourceAccessor;
import etm.core.configuration.EtmManager;
import etm.core.monitor.EtmMonitor;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HttpConsoleServlet
extends HttpServlet {
    public static final String EXPANDED_RESULTS = "expanded";
    protected ActionRegistry actionRegistry;
    protected EtmMonitor etmMonitor;
    protected ServletConfig servletConfig;

    public void init(ServletConfig aServletConfig) throws ServletException {
        super.init(aServletConfig);
        this.servletConfig = aServletConfig;
        boolean expanded = "true".equalsIgnoreCase(this.servletConfig.getInitParameter(EXPANDED_RESULTS));
        this.actionRegistry = new ActionRegistry(new ResourceAccessor(), expanded);
        this.etmMonitor = this.getEtmMonitor();
    }

    protected void doGet(HttpServletRequest aHttpServletRequest, HttpServletResponse aHttpServletResponse) throws ServletException, IOException {
        ConsoleAction action;
        String actionName = null;
        String requestUri = aHttpServletRequest.getRequestURI();
        int i = requestUri.lastIndexOf("/");
        if (i >= 0) {
            actionName = requestUri.substring(i);
        }
        if (actionName == null || actionName.isEmpty()) {
            actionName = "/";
        }
        if ((action = this.actionRegistry.getAction(actionName)) == null) {
            aHttpServletResponse.sendError(404);
            return;
        }
        action.execute(new ServletConsoleRequest(this.etmMonitor, aHttpServletRequest), new ServletConsoleResponse(aHttpServletResponse));
    }

    protected EtmMonitor getEtmMonitor() throws ServletException {
        return EtmManager.getEtmMonitor();
    }
}

