/*
 * Decompiled with CFR 0.152.
 */
package etm.contrib.console;

import etm.contrib.console.ConsoleRequest;
import etm.contrib.console.ConsoleResponse;
import etm.contrib.console.standalone.StandaloneConsoleRequest;
import etm.contrib.console.util.CollapsedResultRenderer;
import etm.contrib.util.ExecutionAggregateComparator;
import etm.core.monitor.EtmMonitor;
import etm.core.renderer.MeasurementRenderer;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.net.InetAddress;
import java.net.Socket;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import junit.framework.TestCase;

public abstract class ConsoleTests
extends TestCase {
    protected EtmMonitor monitor;

    public void testResultRendering() throws Exception {
        String serverResponse = this.executeRequest("/index");
        final ByteArrayOutputStream out = new ByteArrayOutputStream();
        StandaloneConsoleRequest request = new StandaloneConsoleRequest(this.monitor);
        ConsoleResponse testResponse = new ConsoleResponse(){
            OutputStreamWriter writer;
            {
                this.writer = new OutputStreamWriter(out);
            }

            public void addHeader(String header, String value) {
            }

            public void write(String content) throws IOException {
                this.writer.write(content);
                this.writer.flush();
            }

            public void write(char[] content) throws IOException {
                this.writer.write(content);
                this.writer.flush();
            }

            public void write(byte[] content) throws IOException {
                out.write(content);
            }

            public void sendRedirect(String target, Map parameters) {
            }

            public void sendStatus(int statusCode, String description) {
            }
        };
        CollapsedResultRenderer renderer = new CollapsedResultRenderer((ConsoleRequest)request, testResponse, new ExecutionAggregateComparator(3, true));
        this.monitor.render((MeasurementRenderer)renderer);
        String expected = new String(out.toByteArray(), "UTF-8");
        String response = serverResponse.substring(serverResponse.indexOf("close") + 5).trim();
        ConsoleTests.assertEquals((String)expected.substring(expected.indexOf("Begin results")), (String)response.substring(response.indexOf("Begin results")));
    }

    public void testMonitorReset() throws Exception {
        this.executeRequest("/reset");
        this.monitor.render(new MeasurementRenderer(){

            public void render(Map points) {
                TestCase.assertEquals((int)0, (int)points.size());
            }
        });
    }

    public void testCollectionStop() throws Exception {
        this.executeRequest("/stop");
        ConsoleTests.assertFalse((boolean)this.monitor.isCollecting());
    }

    public void testCollectionStart() throws Exception {
        this.monitor.disableCollection();
        this.executeRequest("/start");
        ConsoleTests.assertTrue((boolean)this.monitor.isCollecting());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String executeRequest(String request) throws Exception {
        Socket socket = new Socket(InetAddress.getLoopbackAddress().getHostAddress(), 40000);
        socket.setSoTimeout(30000);
        OutputStream outputStream = socket.getOutputStream();
        outputStream.write(("GET " + request + " HTTP/1.0\n").getBytes());
        outputStream.flush();
        byte[] buffer = new byte[65535];
        int pos = 0;
        InputStream in = socket.getInputStream();
        try {
            int r;
            while ((r = in.read(buffer, pos, buffer.length - pos)) > -1) {
                pos += r;
            }
        }
        catch (Exception e) {
            System.out.println("got buffer content " + new String(buffer));
            ThreadMXBean mxBean = ManagementFactory.getThreadMXBean();
            ThreadInfo[] threadInfos = mxBean.getThreadInfo(mxBean.getAllThreadIds(), 0);
            HashMap<Long, ThreadInfo> threadInfoMap = new HashMap<Long, ThreadInfo>();
            for (int i = 0; i < threadInfos.length; ++i) {
                ThreadInfo threadInfo = threadInfos[i];
                threadInfoMap.put(new Long(threadInfo.getThreadId()), threadInfo);
            }
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(System.out));
            try {
                this.dumpTraces(mxBean, threadInfoMap, writer);
            }
            finally {
                ((Writer)writer).close();
            }
        }
        finally {
            in.close();
            socket.close();
        }
        return new String(buffer);
    }

    private void dumpTraces(ThreadMXBean mxBean, Map threadInfoMap, Writer writer) throws IOException {
        Map<Thread, StackTraceElement[]> stacks = Thread.getAllStackTraces();
        writer.write("Dump of " + stacks.size() + " thread at " + new SimpleDateFormat("yyyy/MM/dd HH:mm:ss z").format(new Date(System.currentTimeMillis())) + "\n\n");
        Iterator<Map.Entry<Thread, StackTraceElement[]>> iterator = stacks.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Thread, StackTraceElement[]> entry = iterator.next();
            Thread thread = entry.getKey();
            writer.write("\"" + thread.getName() + "\" prio=" + thread.getPriority() + " tid=" + thread.getId() + " " + (Object)((Object)thread.getState()) + " " + (thread.isDaemon() ? "deamon" : "worker") + "\n");
            ThreadInfo threadInfo = (ThreadInfo)threadInfoMap.get(new Long(thread.getId()));
            if (threadInfo != null) {
                writer.write("    native=" + threadInfo.isInNative() + ", suspended=" + threadInfo.isSuspended() + ", block=" + threadInfo.getBlockedCount() + ", wait=" + threadInfo.getWaitedCount() + "\n");
                writer.write("    lock=" + threadInfo.getLockName() + " owned by " + threadInfo.getLockOwnerName() + " (" + threadInfo.getLockOwnerId() + "), cpu=" + mxBean.getThreadCpuTime(threadInfo.getThreadId()) / 1000000L + ", user=" + mxBean.getThreadUserTime(threadInfo.getThreadId()) / 1000000L + "\n");
            }
            StackTraceElement[] elements = entry.getValue();
            for (int i = 0; i < elements.length; ++i) {
                writer.write("        ");
                writer.write(elements[i].toString());
                writer.write("\n");
            }
            writer.write("\n");
        }
    }
}

