/*
 * Decompiled with CFR 0.152.
 */
package etm.contrib.console.actions;

import etm.contrib.console.ConsoleAction;
import etm.contrib.console.ConsoleRequest;
import etm.contrib.console.ConsoleResponse;
import etm.contrib.console.actions.CollapsedResultViewAction;
import etm.contrib.console.actions.DetailAction;
import etm.contrib.console.actions.ExpandedResultViewAction;
import etm.contrib.console.actions.RedirectAction;
import etm.contrib.console.actions.ResetMonitorAction;
import etm.contrib.console.actions.ResourceAction;
import etm.contrib.console.actions.StartMonitorAction;
import etm.contrib.console.actions.StopMonitorAction;
import etm.contrib.console.util.ResourceAccessor;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class ActionRegistry {
    private Map actions = new HashMap();

    public ActionRegistry(ResourceAccessor resourceAccessor, boolean expanded) {
        if (expanded) {
            this.enableExpanded();
        } else {
            this.enableCollapsed();
        }
        this.actions.put("/", new RedirectAction("index"));
        this.actions.put("/reset", new ResetMonitorAction());
        this.actions.put("/start", new StartMonitorAction());
        this.actions.put("/stop", new StopMonitorAction());
        this.actions.put("/style.css", new ResourceAction("text/css;charset=UTF-8", resourceAccessor.getStyleSheet()));
        this.actions.put("/robots.txt", new ResourceAction("text/plain;charset=UTF-8", resourceAccessor.getRobotsTxt()));
        this.actions.put("/favicon.ico", new ResourceAction("image/x-icon", resourceAccessor.getFavicon()));
        this.actions.put("/down-arrow.png", new ResourceAction("image/png", resourceAccessor.getDownarrow()));
        this.actions.put("/up-arrow.png", new ResourceAction("image/png", resourceAccessor.getUparrow()));
        this.actions.put("/detail", new DetailAction());
        this.actions.put("/expand", new RedirectAction("index"){

            public void execute(ConsoleRequest request, ConsoleResponse response) throws IOException {
                ActionRegistry.this.enableExpanded();
                super.execute(request, response);
            }
        });
        this.actions.put("/collapse", new RedirectAction("index"){

            public void execute(ConsoleRequest request, ConsoleResponse response) throws IOException {
                ActionRegistry.this.enableCollapsed();
                super.execute(request, response);
            }
        });
    }

    public ConsoleAction getAction(String action) {
        return (ConsoleAction)this.actions.get(action);
    }

    private void enableCollapsed() {
        this.actions.put("/index", new CollapsedResultViewAction());
    }

    private void enableExpanded() {
        this.actions.put("/index", new ExpandedResultViewAction());
    }
}

