/*
 * Decompiled with CFR 0.152.
 */
package etm.contrib.rrd.rrd4j;

import etm.contrib.aggregation.filter.RegexEtmFilter;
import etm.contrib.rrd.core.RrdDestination;
import etm.contrib.rrd.core.RrdExecutionWriter;
import etm.contrib.rrd.rrd4j.Rrd4jAggregationWriter;
import etm.core.aggregation.EtmFilter;
import etm.core.monitor.EtmException;
import etm.core.monitor.EtmPoint;
import java.io.File;
import java.io.IOException;
import org.rrd4j.core.RrdDb;

public class Rrd4jDestination
implements RrdDestination {
    private String pattern;
    private File rrdFilePath;
    private RrdDb rrdDb;
    private EtmFilter filter;
    private RrdExecutionWriter writer;

    public Rrd4jDestination(String aPattern, File aRrdFilePath) {
        this.pattern = aPattern;
        this.rrdFilePath = aRrdFilePath;
    }

    public void start() {
        this.filter = "*".equals(this.pattern) ? new EtmFilter(){

            public boolean matches(EtmPoint aEtmPoint) {
                return true;
            }
        } : new RegexEtmFilter(this.pattern);
        try {
            this.rrdDb = new RrdDb(this.rrdFilePath.getAbsolutePath());
        }
        catch (IOException e) {
            throw new EtmException((Throwable)e);
        }
        this.writer = new Rrd4jAggregationWriter(this.rrdDb);
        this.writer.onBegin();
    }

    public void stop() {
        this.writer.onFinish();
        try {
            if (this.rrdDb != null) {
                this.rrdDb.close();
            }
        }
        catch (IOException e) {
            throw new EtmException((Throwable)e);
        }
    }

    public boolean matches(EtmPoint point) {
        return this.filter.matches(point);
    }

    public void write(EtmPoint point) {
        this.writer.onNextMeasurement(point);
    }

    public String toString() {
        return "Rrd4jDestination [" + this.rrdFilePath.getAbsolutePath() + "|" + this.pattern + "]";
    }
}

