/*
 * Decompiled with CFR 0.152.
 */
package etm.contrib.rrd.core;

import etm.contrib.rrd.core.RrdDestination;
import etm.core.metadata.AggregatorMetaData;
import etm.core.monitor.EtmException;
import etm.core.monitor.EtmMonitorContext;
import etm.core.monitor.event.CollectEvent;
import etm.core.monitor.event.CollectionListener;
import etm.core.plugin.EtmPlugin;
import etm.core.util.Log;
import etm.core.util.LogAdapter;
import java.util.ArrayList;

public abstract class AbstractRrdPlugin
implements EtmPlugin,
CollectionListener {
    private static final LogAdapter log = Log.getLog((Class)AbstractRrdPlugin.class);
    protected EtmMonitorContext ctx;
    protected RrdDestination[] destinations;
    static /* synthetic */ Class class$etm$core$aggregation$NotifyingAggregator;

    public void init(EtmMonitorContext aCtx) {
        this.ctx = aCtx;
    }

    public void start() {
        this.doValidateChain();
        RrdDestination[] tmp = this.getDestinations();
        ArrayList<RrdDestination> dest = new ArrayList<RrdDestination>();
        for (int i = 0; i < tmp.length; ++i) {
            RrdDestination rrdDestination = tmp[i];
            try {
                rrdDestination.start();
                dest.add(rrdDestination);
                log.debug("Added RRD destination " + rrdDestination);
                continue;
            }
            catch (Exception e) {
                log.warn("Error activation RRD destination " + rrdDestination, (Throwable)e);
            }
        }
        this.destinations = dest.toArray(new RrdDestination[dest.size()]);
    }

    public void stop() {
        RrdDestination[] saved = this.destinations;
        this.destinations = new RrdDestination[0];
        if (saved != null) {
            for (int i = 0; i < saved.length; ++i) {
                if (saved[i] == null) continue;
                saved[i].stop();
            }
        }
    }

    public void onCollect(CollectEvent event) {
        for (int i = 0; i < this.destinations.length; ++i) {
            RrdDestination destination = this.destinations[i];
            if (!destination.matches(event.getPoint())) continue;
            destination.write(event.getPoint());
        }
    }

    protected void doValidateChain() {
        for (AggregatorMetaData metaData = this.ctx.getEtmMonitor().getMetaData().getAggregatorMetaData(); metaData != null; metaData = metaData.getNestedMetaData()) {
            if (!metaData.getImplementationClass().isAssignableFrom(class$etm$core$aggregation$NotifyingAggregator == null ? AbstractRrdPlugin.class$("etm.core.aggregation.NotifyingAggregator") : class$etm$core$aggregation$NotifyingAggregator)) continue;
            return;
        }
        throw new EtmException("Missing NotifyingAggregator. There has to be a NotifyingAggregator in your aggregation chain. Rrd support disabled.");
    }

    protected abstract RrdDestination[] getDestinations();
}

