/*
 * Decompiled with CFR 0.152.
 */
package etm.contrib.rrd.rrd4j;

import etm.contrib.rrd.core.AbstractRrdPlugin;
import etm.contrib.rrd.core.RrdDestination;
import etm.contrib.rrd.rrd4j.Rrd4jDestination;
import etm.core.metadata.PluginMetaData;
import etm.core.util.Log;
import etm.core.util.LogAdapter;
import java.io.File;
import java.util.HashMap;
import java.util.List;

public class Rrd4jPlugin
extends AbstractRrdPlugin {
    private static final LogAdapter log = Log.getLog((Class)Rrd4jPlugin.class);
    private String configPath = System.getProperty("java.io.tmpdir");
    private List destinationConfiguration;

    public Rrd4jPlugin() {
        log.warn("You are about to use an experimental JETM feature. Please report issues with it. Thanks.");
    }

    public void setRrdFilePath(String path) {
        this.configPath = path;
    }

    public void setDestinations(List aDestinations) {
        this.destinationConfiguration = aDestinations;
    }

    protected RrdDestination[] getDestinations() {
        if (this.destinationConfiguration == null) {
            return new RrdDestination[0];
        }
        this.destinations = new RrdDestination[this.destinationConfiguration.size()];
        for (int i = 0; i < this.destinationConfiguration.size(); ++i) {
            String s = (String)this.destinationConfiguration.get(i);
            int index = s.indexOf(33);
            String filename = s.substring(0, index);
            String pattern = s.substring(index + 1);
            this.destinations[i] = new Rrd4jDestination(pattern, new File(this.configPath, filename));
        }
        return this.destinations;
    }

    public PluginMetaData getPluginMetaData() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("configPath", this.configPath);
        if (this.destinationConfiguration != null) {
            config.put("destinationConfiguration", this.destinationConfiguration.toString());
        }
        return new PluginMetaData(this.getClass(), "RRD4j plugin.", config);
    }
}

