/*
 * Decompiled with CFR 0.152.
 */
package de.openknowledge.cdi.monitoring;

import de.openknowledge.cdi.monitoring.ComponentStatusType;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang.exception.ExceptionUtils;

public class ComponentStatus {
    private ComponentStatusType status;
    private String component;
    private String statusMessage;

    public ComponentStatus(String aComponent) {
        this.component = aComponent;
        this.status = ComponentStatusType.OK;
    }

    public ComponentStatus(Class aClazz) {
        this(aClazz.getSimpleName());
    }

    public ComponentStatus(String aComponent, ComponentStatusType aStatus, String aStatusMessage) {
        this.component = aComponent;
        this.status = aStatus;
        this.statusMessage = aStatusMessage;
    }

    public ComponentStatus(Class aClazz, ComponentStatusType aStatus, String aStatusMessage) {
        this(aClazz.getSimpleName(), aStatus, aStatusMessage);
    }

    public ComponentStatus(String aComponent, Throwable t) {
        this.status = ComponentStatusType.ERROR;
        this.component = aComponent;
        this.statusMessage = this.serializeError(t);
    }

    public ComponentStatus(Class aClazz, Throwable t) {
        this(aClazz.getSimpleName(), t);
    }

    public ComponentStatus(String aComponent, String aStatusMessage, Throwable t) {
        this.status = ComponentStatusType.ERROR;
        this.component = aComponent;
        this.statusMessage = aStatusMessage + " - " + this.serializeError(t);
    }

    public ComponentStatus(Class aClazz, String aStatusMessage, Throwable t) {
        this(aClazz.getSimpleName(), aStatusMessage, t);
    }

    public ComponentStatusType getStatus() {
        return this.status;
    }

    public String getComponent() {
        return this.component;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public boolean isOK() {
        return this.status == ComponentStatusType.OK;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.component);
        sb.append(" - ");
        sb.append((Object)this.status);
        if (this.statusMessage != null) {
            sb.append(" (");
            int i = this.statusMessage.indexOf("\n");
            if (i > 0) {
                sb.append(this.statusMessage.substring(0, i));
            } else {
                sb.append(this.statusMessage);
            }
            sb.append(")");
        }
        return sb.toString();
    }

    protected String serializeError(Throwable aT) {
        return ExceptionUtils.getMessage((Throwable)aT) + SystemUtils.LINE_SEPARATOR + ExceptionUtils.getStackTrace((Throwable)aT);
    }
}

