/*
 * Decompiled with CFR 0.152.
 */
package de.openknowledge.util.dge.grouping;

import de.openknowledge.util.dge.grouping.AggregationLine;
import de.openknowledge.util.dge.grouping.Group;
import de.openknowledge.util.dge.grouping.GroupingManager;
import de.openknowledge.util.dge.grouping.GroupingMetaData;
import de.openknowledge.util.dge.grouping.ValueLine;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GroupingManagerTest {
    List<Foo> foos;

    @Before
    public void init() {
        this.foos = new ArrayList<Foo>();
        this.foos.add(new Foo("Marc", "Today"));
        this.foos.add(new Foo("Marc", "Tomorrow"));
        this.foos.add(new Foo("Jens", "Today"));
        this.foos.add(new Foo("Jens", "Yesterday"));
        this.foos.add(new Foo("Bartug", "Yesterday"));
        this.foos.add(new Foo("Bartug", "Tomorrow"));
    }

    @Test
    public void groupingMetaDataTest() {
        GroupingManager manager = new GroupingManager(this.foos, Foo.class);
        List metaData = manager.getGroupingMetaData();
        Assert.assertThat((Object)((GroupingMetaData)metaData.get(0)).getOrder(), (Matcher)CoreMatchers.is((Object)100));
        Assert.assertThat((Object)((GroupingMetaData)metaData.get(1)).getOrder(), (Matcher)CoreMatchers.is((Object)200));
    }

    @Test
    public void groupByTest() {
        GroupingManager manager = new GroupingManager(this.foos, Foo.class);
        manager.groupBy("Bar");
        Assert.assertThat((Object)((AggregationLine)manager.getGroupedLines().get(0)).getDisplayName(), (Matcher)CoreMatchers.is((Object)"Bartug"));
        Assert.assertThat((Object)((AggregationLine)manager.getGroupedLines().get(1)).getDisplayName(), (Matcher)CoreMatchers.is((Object)"Jens"));
        Assert.assertThat((Object)((AggregationLine)manager.getGroupedLines().get(2)).getDisplayName(), (Matcher)CoreMatchers.is((Object)"Marc"));
    }

    @Test
    public void initGroupTest() throws Exception {
        GroupingManager manager = new GroupingManager(this.foos, Foo.class);
        Assert.assertThat((Object)((Foo)((ValueLine)manager.getGroupedLines().get(0)).getObject()).getBar(), (Matcher)CoreMatchers.is((Object)"Marc"));
        Assert.assertThat((Object)((Foo)((ValueLine)manager.getGroupedLines().get(4)).getObject()).getBar(), (Matcher)CoreMatchers.is((Object)"Bartug"));
        Assert.assertThat((Object)((Foo)((ValueLine)manager.getGroupedLines().get(5)).getObject()).getBar(), (Matcher)CoreMatchers.is((Object)"Bartug"));
    }

    public class Foo
    implements Serializable {
        private String bar;
        private String yadda;

        public Foo(String aBar, String aYadda) {
            this.bar = aBar;
            this.yadda = aYadda;
        }

        @Group(order=100, displayName="Bar")
        public String getBar() {
            return this.bar;
        }

        @Group(order=200, displayName="Yadda")
        public String getYadda() {
            return this.yadda;
        }
    }
}

