/*
 * Decompiled with CFR 0.152.
 */
package de.openknowledge.cdi.inject;

import de.openknowledge.cdi.inject.ApplicationScopedBean;
import de.openknowledge.cdi.inject.ObjectInstance;
import de.openknowledge.cdi.test.CdiJunit4TestRunner;
import java.lang.annotation.Annotation;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.AmbiguousResolutionException;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.util.AnnotationLiteral;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=CdiJunit4TestRunner.class)
public class ObjectInstanceTest {
    @Inject
    private BeanManager beanManager;

    @Test(expected=AmbiguousResolutionException.class)
    public void get() {
        new ObjectInstance().get();
    }

    @Test
    public void isAmbiguous() {
        Assert.assertTrue((boolean)new ObjectInstance().isAmbiguous());
    }

    @Test
    public void isUnsatisfied() {
        Assert.assertFalse((boolean)new ObjectInstance().isUnsatisfied());
    }

    @Test
    public void iterator() {
    }

    @Test
    public void select() {
        ObjectInstance objectInstance = new ObjectInstance();
        Instance defaultInstance = objectInstance.select(new Annotation[]{new AnnotationLiteral<Default>(){}});
        Assert.assertFalse((boolean)defaultInstance.isUnsatisfied());
        Assert.assertTrue((boolean)defaultInstance.isAmbiguous());
        Bean bean = this.beanManager.resolve(this.beanManager.getBeans(ApplicationScopedBean.class, new Annotation[0]));
        CreationalContext creationalContext = this.beanManager.createCreationalContext((Contextual)bean);
        ApplicationScopedBean contextualReference = (ApplicationScopedBean)this.beanManager.getReference(bean, ApplicationScopedBean.class, creationalContext);
        ApplicationScopedBean applicationScopedBean = (ApplicationScopedBean)objectInstance.select(ApplicationScopedBean.class, new Annotation[0]).get();
        Assert.assertEquals((Object)contextualReference, (Object)applicationScopedBean);
    }
}

