/*
 * Decompiled with CFR 0.152.
 */
package de.openknowledge.cdi.monitoring;

import de.openknowledge.cdi.monitoring.ComponentStatus;
import de.openknowledge.cdi.monitoring.HealthStatusQueryCommand;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class ValidationTemplate {
    private static final Log LOG = LogFactory.getLog(ValidationTemplate.class);
    private Class componentClass;

    protected ValidationTemplate(Class aComponentClass) {
        this.componentClass = aComponentClass;
    }

    public void validate(HealthStatusQueryCommand event) {
        try {
            this.doValidate(event);
        }
        catch (Throwable t) {
            LOG.error((Object)("Validation error in " + this.componentClass.getSimpleName()), t);
            event.reportStatus(new ComponentStatus(this.componentClass, t));
        }
    }

    public abstract void doValidate(HealthStatusQueryCommand var1);
}

