/*
 * Decompiled with CFR 0.152.
 */
package etm.contrib.integration.cdi;

import etm.contrib.integration.cdi.ApplyTo;
import etm.contrib.integration.cdi.Measure;
import etm.contrib.integration.cdi.de.openknowledge.cdi.common.spi.AbstractCdiBean;
import etm.contrib.integration.cdi.de.openknowledge.cdi.common.spi.DelegatingAnnotatedMethod;
import etm.contrib.integration.cdi.de.openknowledge.cdi.common.spi.DelegatingAnnotatedType;
import etm.core.configuration.BasicEtmConfigurator;
import etm.core.configuration.EtmManager;
import etm.core.configuration.EtmMonitorConfig;
import etm.core.configuration.EtmMonitorFactory;
import etm.core.configuration.XmlConfigParser;
import etm.core.monitor.EtmException;
import etm.core.monitor.EtmMonitor;
import etm.core.util.Log;
import etm.core.util.LogAdapter;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.util.AnnotationLiteral;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QualifiedEtmExtension
implements Extension {
    private static final LogAdapter LOG = Log.getLog(EtmMonitor.class);
    private static final String DEFAULT_CONFIG_FILE = "jetm-config.xml";
    private EtmMonitorConfig monitorConfig;
    private boolean delayedAutoStart;
    private EtmMonitor etmMonitor;
    private ApplyToResolver resolver = new ApplyToResolver();

    public void beforeScan(@Observes BeforeBeanDiscovery event) {
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(DEFAULT_CONFIG_FILE);
        try {
            if (in != null) {
                this.monitorConfig = XmlConfigParser.extractConfig((InputStream)in);
                this.delayedAutoStart = this.monitorConfig.isAutostart();
                this.monitorConfig.setAutostart(false);
            } else {
                this.delayedAutoStart = true;
            }
        }
        catch (Exception e) {
            throw new EtmException((Throwable)e);
        }
    }

    public void afterScan(@Observes AfterBeanDiscovery event, BeanManager bm) {
        try {
            if (this.monitorConfig != null) {
                this.etmMonitor = EtmMonitorFactory.createEtmMonitor((EtmMonitorConfig)this.monitorConfig);
                CdiEtmManager.configure(this.etmMonitor);
            } else {
                BasicEtmConfigurator.configure((boolean)true);
                this.etmMonitor = EtmManager.getEtmMonitor();
            }
        }
        catch (Exception e) {
            event.addDefinitionError((Throwable)e);
            return;
        }
        event.addBean((Bean)new EtmMonitorBean(bm, this.etmMonitor));
    }

    public void afterDeployment(@Observes AfterDeploymentValidation event) {
        if (this.delayedAutoStart) {
            this.etmMonitor.start();
        }
    }

    public <T> void addMeasurement(@Observes ProcessAnnotatedType<T> event) {
        AnnotatedType annotatedType = event.getAnnotatedType();
        if (!annotatedType.isAnnotationPresent(Measure.class)) {
            AnnotationLiteral<Measure> annotationLiteral = new AnnotationLiteral<Measure>(){};
            if (this.resolver.isQualifiedApiType(annotatedType)) {
                event.setAnnotatedType(new DelegatingAnnotatedType(annotatedType, new Annotation[]{annotationLiteral}));
            } else if (this.resolver.isQualifiedMethodType(annotatedType)) {
                event.setAnnotatedType(new ApplyToDelegatingAnnotatedType(annotatedType));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ApplyToDelegatingAnnotatedType<T>
    extends DelegatingAnnotatedType<T> {
        public ApplyToDelegatingAnnotatedType(AnnotatedType<T> delegateType) {
            super(delegateType, new Annotation[0]);
        }

        @Override
        protected AnnotatedMethod<? super T> processAnnotatedMethod(AnnotatedMethod<? super T> method) {
            String name = method.getJavaMember().getName();
            if (!(name.startsWith("get") || name.startsWith("set") || name.startsWith("is") || method.isAnnotationPresent(Measure.class))) {
                return new DelegatingAnnotatedMethod<T>(this, method, new Annotation[]{new AnnotationLiteral<Measure>(){}});
            }
            return method;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ApplyToResolver {
        private Map<String, ApplyTo> cache = new HashMap<String, ApplyTo>();

        ApplyToResolver() {
        }

        protected <T> boolean isQualifiedApiType(AnnotatedType<T> type) {
            ApplyTo applyTo = this.findApplyTo(type.getJavaClass().getPackage().getName(), type);
            if (applyTo != null) {
                for (Class<? extends Annotation> t : applyTo.qualifiedApi()) {
                    if (!type.isAnnotationPresent(t)) continue;
                    return true;
                }
            }
            return false;
        }

        protected <T> boolean isQualifiedMethodType(AnnotatedType<T> type) {
            ApplyTo applyTo = this.findApplyTo(type.getJavaClass().getPackage().getName(), type);
            if (applyTo != null) {
                for (Class<? extends Annotation> t : applyTo.qualifiedMethod()) {
                    if (!type.isAnnotationPresent(t)) continue;
                    return true;
                }
            }
            return false;
        }

        protected <T> ApplyTo findApplyTo(String packageName, AnnotatedType<T> type) {
            if (this.cache.containsKey(packageName)) {
                return this.cache.get(packageName);
            }
            ArrayList<String> packages = new ArrayList<String>();
            ApplyTo result = this.recursiveSearch(packageName, packages);
            for (String pkg : packages) {
                this.cache.put(pkg, result);
            }
            return this.findApplyTo(packageName, type);
        }

        private ApplyTo recursiveSearch(String packageName, List<String> aPackages) {
            aPackages.add(packageName);
            ApplyTo cached = this.cache.get(packageName);
            if (cached != null) {
                return cached;
            }
            Package aPackage = Package.getPackage(packageName);
            if (aPackage != null && aPackage.isAnnotationPresent(ApplyTo.class)) {
                ApplyTo annotation = aPackage.getAnnotation(ApplyTo.class);
                LOG.info("Using " + annotation + " for " + aPackage.getName() + " and above.");
                return annotation;
            }
            if (packageName.contains(".")) {
                return this.recursiveSearch(this.getParentPackage(packageName), aPackages);
            }
            return null;
        }

        protected String getParentPackage(String aPackage) {
            int i = aPackage.lastIndexOf(46);
            if (i >= 0) {
                return aPackage.substring(0, i);
            }
            return null;
        }
    }

    static class CdiEtmManager
    extends EtmManager {
        CdiEtmManager() {
        }

        protected static void configure(EtmMonitor aEtmMonitor) {
            EtmManager.configure((EtmMonitor)aEtmMonitor);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class EtmMonitorBean
    extends AbstractCdiBean<EtmMonitor> {
        private EtmMonitor etmMonitor;

        public EtmMonitorBean(BeanManager beanManager, EtmMonitor aEtmMonitor) {
            super(null, EtmMonitor.class, beanManager, new Annotation[0]);
            this.etmMonitor = aEtmMonitor;
        }

        public EtmMonitor create(CreationalContext<EtmMonitor> context) {
            return this.etmMonitor;
        }

        public void destroy(EtmMonitor instance, CreationalContext<EtmMonitor> context) {
            instance.stop();
        }

        @Override
        public Class<? extends Annotation> getScope() {
            return ApplicationScoped.class;
        }
    }
}

