/*
 * Decompiled with CFR 0.152.
 */
package etm.contrib.console;

import etm.contrib.console.util.ConsoleUtil;
import java.util.Map;
import junit.framework.TestCase;

public class ParameterExtractionTest
extends TestCase {
    public void testExtraction() {
        byte[] buffer = new byte[3000];
        int eol = this.fillRequest(buffer, "/test?foo=bar");
        Map params = ConsoleUtil.extractRequestParameters((byte[])buffer, (int)9, (int)eol);
        ParameterExtractionTest.assertEquals((int)1, (int)params.size());
        ParameterExtractionTest.assertEquals((Object)"bar", params.get("foo"));
        eol = this.fillRequest(buffer, "/test?foo");
        params = ConsoleUtil.extractRequestParameters((byte[])buffer, (int)9, (int)eol);
        ParameterExtractionTest.assertEquals((int)1, (int)params.size());
        ParameterExtractionTest.assertEquals((Object)"", params.get("foo"));
        eol = this.fillRequest(buffer, "/test?foo=bar&xyz=yadda");
        params = ConsoleUtil.extractRequestParameters((byte[])buffer, (int)9, (int)eol);
        ParameterExtractionTest.assertEquals((int)2, (int)params.size());
        ParameterExtractionTest.assertEquals((Object)"bar", params.get("foo"));
        ParameterExtractionTest.assertEquals((Object)"yadda", params.get("xyz"));
        eol = this.fillRequest(buffer, "/test?foo&xyz=yadda");
        params = ConsoleUtil.extractRequestParameters((byte[])buffer, (int)9, (int)eol);
        ParameterExtractionTest.assertEquals((int)2, (int)params.size());
        ParameterExtractionTest.assertEquals((Object)"", params.get("foo"));
        ParameterExtractionTest.assertEquals((Object)"yadda", params.get("xyz"));
        eol = this.fillRequest(buffer, "/test?foo=bar&xyz");
        params = ConsoleUtil.extractRequestParameters((byte[])buffer, (int)9, (int)eol);
        ParameterExtractionTest.assertEquals((int)2, (int)params.size());
        ParameterExtractionTest.assertEquals((Object)"bar", params.get("foo"));
        ParameterExtractionTest.assertEquals((Object)"", params.get("xyz"));
        eol = this.fillRequest(buffer, "/?foo=bar");
        params = ConsoleUtil.extractRequestParameters((byte[])buffer, (int)5, (int)eol);
        ParameterExtractionTest.assertEquals((int)1, (int)params.size());
        ParameterExtractionTest.assertEquals((Object)"bar", params.get("foo"));
        eol = this.fillRequest(buffer, "/?foo=bar&xyz");
        params = ConsoleUtil.extractRequestParameters((byte[])buffer, (int)5, (int)eol);
        ParameterExtractionTest.assertEquals((int)2, (int)params.size());
        ParameterExtractionTest.assertEquals((Object)"bar", params.get("foo"));
        ParameterExtractionTest.assertEquals((Object)"", params.get("xyz"));
    }

    private int fillRequest(byte[] buffer, String string) {
        byte[] request = ("GET " + string).getBytes();
        System.arraycopy(request, 0, buffer, 0, request.length);
        return request.length;
    }
}

