/*
 * Decompiled with CFR 0.152.
 */
package etm.contrib.integration.jee.jsf;

import etm.contrib.integration.jee.jsf.EtmJsfPlugin;
import etm.core.configuration.EtmManager;
import etm.core.metadata.PluginMetaData;
import etm.core.monitor.EtmMonitor;
import etm.core.util.Log;
import etm.core.util.LogAdapter;
import java.lang.reflect.Constructor;
import java.util.Iterator;
import javax.faces.context.FacesContext;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;

public class DelegatingEtmRenderKitFactory
extends RenderKitFactory {
    private static final LogAdapter LOG = Log.getLog(DelegatingEtmRenderKitFactory.class);
    private static final String CGLIB_DELEGATE_CLASS_NAME = "etm.contrib.integration.jee.jsf.wrapped.CGlibDelegatingRenderKitFactory";
    private RenderKitFactory delegate;

    public DelegatingEtmRenderKitFactory(RenderKitFactory aKitFactory) {
        this.delegate = aKitFactory;
        if (!this.isEnabled().booleanValue()) {
            LOG.info("JSF component monitoring disabled.");
        } else if (this.isCglibAvailable()) {
            try {
                Class<?> aClass = Class.forName(CGLIB_DELEGATE_CLASS_NAME);
                Constructor<?> constructor = aClass.getConstructor(RenderKitFactory.class);
                this.delegate = (RenderKitFactory)constructor.newInstance(aKitFactory);
                LOG.debug("Activated JSF component monitoring.");
            }
            catch (Exception e) {
                LOG.warn("Unable to create CGLIB proxy for " + aKitFactory.getClass() + ". Component monitoring disabled: " + e.getMessage());
            }
        } else {
            LOG.warn("CGLIB not found. Component monitoring disabled.");
        }
    }

    public void addRenderKit(String renderKitId, RenderKit renderKit) {
        this.delegate.addRenderKit(renderKitId, renderKit);
    }

    public RenderKit getRenderKit(FacesContext context, String renderKitId) {
        return this.delegate.getRenderKit(context, renderKitId);
    }

    public Iterator<String> getRenderKitIds() {
        return this.delegate.getRenderKitIds();
    }

    public RenderKitFactory getWrapped() {
        return this.delegate;
    }

    protected Boolean isEnabled() {
        String obj;
        Boolean enabled = false;
        EtmMonitor monitor = EtmManager.getEtmMonitor();
        PluginMetaData pluginMetaData = monitor.getMetaData().getPluginMetaData(EtmJsfPlugin.class);
        if (pluginMetaData != null && (obj = (String)pluginMetaData.getProperties().get("EtmJsfPlugin.componentMonitoring")) != null) {
            enabled = Boolean.parseBoolean(obj);
        }
        return enabled;
    }

    protected boolean isCglibAvailable() {
        try {
            Class.forName("net.sf.cglib.proxy.Enhancer", false, this.delegate.getClass().getClassLoader());
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

