/*
 * Decompiled with CFR 0.152.
 */
package etm.contrib.integration.spring.configuration;

import etm.contrib.aggregation.log.CommonsLoggingAggregator;
import etm.contrib.aggregation.log.Log4jAggregator;
import etm.contrib.integration.spring.configuration.ConfigurationTestCase;
import etm.contrib.integration.spring.configuration.mockup.SpringRootAggregator;
import etm.contrib.renderer.plugin.Log4jDumpOnShutdownPlugin;
import etm.contrib.renderer.plugin.SystemOutDumpOnShutdownPlugin;
import etm.core.aggregation.BufferedTimedAggregator;
import etm.core.aggregation.persistence.PersistentRootAggregator;
import etm.core.metadata.AggregatorMetaData;
import etm.core.metadata.EtmMonitorMetaData;
import etm.core.metadata.PluginMetaData;
import etm.core.monitor.EtmMonitor;
import etm.core.monitor.NestedMonitor;
import etm.core.timer.DefaultTimer;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class RuntimeConfigurationTest
extends ConfigurationTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRuntimeFeatures() {
        ClassPathXmlApplicationContext ctx = this.getContext("runtime-features.xml");
        try {
            ctx.start();
            String[] monitors = ctx.getBeanNamesForType(EtmMonitor.class);
            RuntimeConfigurationTest.assertEquals((int)1, (int)monitors.length);
            EtmMonitor monitor = (EtmMonitor)ctx.getBean(monitors[0]);
            EtmMonitorMetaData etmMonitorMetaData = monitor.getMetaData();
            RuntimeConfigurationTest.assertEquals((Object)BufferedTimedAggregator.class, (Object)etmMonitorMetaData.getAggregatorMetaData().getImplementationClass());
            RuntimeConfigurationTest.assertEquals((Object)Log4jAggregator.class, (Object)etmMonitorMetaData.getAggregatorMetaData().getNestedMetaData().getImplementationClass());
            RuntimeConfigurationTest.assertEquals((Object)PersistentRootAggregator.class, (Object)etmMonitorMetaData.getAggregatorMetaData().getNestedMetaData().getNestedMetaData().getImplementationClass());
            RuntimeConfigurationTest.assertEquals((Object)DefaultTimer.class, (Object)etmMonitorMetaData.getTimerMetaData().getImplementationClass());
        }
        finally {
            ctx.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRuntimePlugins() {
        ClassPathXmlApplicationContext ctx = this.getContext("runtime-plugin.xml");
        try {
            ctx.start();
            String[] monitors = ctx.getBeanNamesForType(EtmMonitor.class);
            RuntimeConfigurationTest.assertEquals((int)1, (int)monitors.length);
            EtmMonitor monitor = (EtmMonitor)ctx.getBean(monitors[0]);
            EtmMonitorMetaData etmMonitorMetaData = monitor.getMetaData();
            RuntimeConfigurationTest.assertEquals((int)2, (int)etmMonitorMetaData.getPluginMetaData().size());
            PluginMetaData pluginOne = (PluginMetaData)etmMonitorMetaData.getPluginMetaData().get(0);
            RuntimeConfigurationTest.assertEquals((Object)Log4jDumpOnShutdownPlugin.class, (Object)pluginOne.getImplementationClass());
            RuntimeConfigurationTest.assertEquals((Object)"fooBar", pluginOne.getProperties().get("logName"));
            PluginMetaData pluginTwo = (PluginMetaData)etmMonitorMetaData.getPluginMetaData().get(1);
            RuntimeConfigurationTest.assertEquals((Object)SystemOutDumpOnShutdownPlugin.class, (Object)pluginTwo.getImplementationClass());
        }
        finally {
            ctx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRuntimeChain() {
        ClassPathXmlApplicationContext ctx = this.getContext("runtime-chain.xml");
        try {
            ctx.start();
            String[] monitors = ctx.getBeanNamesForType(EtmMonitor.class);
            RuntimeConfigurationTest.assertEquals((int)1, (int)monitors.length);
            EtmMonitor monitor = (EtmMonitor)ctx.getBean(monitors[0]);
            RuntimeConfigurationTest.assertEquals((Object)NestedMonitor.class, monitor.getClass());
            EtmMonitorMetaData etmMonitorMetaData = monitor.getMetaData();
            AggregatorMetaData firstElement = etmMonitorMetaData.getAggregatorMetaData();
            RuntimeConfigurationTest.assertEquals((Object)BufferedTimedAggregator.class, (Object)firstElement.getImplementationClass());
            AggregatorMetaData secondElement = firstElement.getNestedMetaData();
            RuntimeConfigurationTest.assertEquals((Object)CommonsLoggingAggregator.class, (Object)secondElement.getImplementationClass());
            AggregatorMetaData thirdElement = secondElement.getNestedMetaData();
            RuntimeConfigurationTest.assertEquals((Object)SpringRootAggregator.class, (Object)thirdElement.getImplementationClass());
        }
        finally {
            ctx.stop();
        }
    }
}

