/*
 * Decompiled with CFR 0.152.
 */
package etm.contrib.aop.spring;

import etm.contrib.aop.aopalliance.EtmMethodCallInterceptor;
import etm.contrib.aop.spring.EtmAdvisor;
import etm.core.monitor.EtmMonitor;
import org.aopalliance.aop.Advice;
import org.springframework.aop.Advisor;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.ProxyConfig;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.target.SingletonTargetSource;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class EtmProxyFactoryBean
extends ProxyConfig
implements FactoryBean,
InitializingBean {
    private EtmMonitor etmMonitor;
    private Object target;
    private Object proxy;

    public void setEtmMonitor(EtmMonitor aEtmMonitor) {
        this.etmMonitor = aEtmMonitor;
    }

    public void setTarget(Object aTarget) {
        this.target = aTarget;
    }

    public Object getObject() throws Exception {
        return this.proxy;
    }

    public Class getObjectType() {
        if (this.proxy != null) {
            return this.proxy.getClass();
        }
        if (this.target instanceof TargetSource) {
            return ((TargetSource)this.target).getTargetClass();
        }
        if (this.target != null) {
            return this.target.getClass();
        }
        return null;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.addAdvisor((Advisor)new EtmAdvisor((Advice)new EtmMethodCallInterceptor(this.etmMonitor)));
        proxyFactory.copyFrom((ProxyConfig)this);
        TargetSource targetSource = this.createTargetSource(this.target);
        proxyFactory.setTargetSource(targetSource);
        this.proxy = proxyFactory.getProxy();
    }

    protected TargetSource createTargetSource(Object target) {
        if (target instanceof TargetSource) {
            return (TargetSource)target;
        }
        return new SingletonTargetSource(target);
    }
}

