/*
 * Decompiled with CFR 0.152.
 */
package etm.contrib.integration.spring.configuration;

import etm.contrib.aggregation.log.CommonsLoggingAggregator;
import etm.contrib.aggregation.log.Jdk14LogAggregator;
import etm.contrib.aggregation.log.Log4jAggregator;
import etm.contrib.integration.spring.configuration.JetmBeanDefinitionParser;
import etm.core.aggregation.BufferedThresholdAggregator;
import etm.core.aggregation.BufferedTimedAggregator;
import etm.core.aggregation.NotifyingAggregator;
import etm.core.aggregation.RootAggregator;
import etm.core.aggregation.persistence.FileSystemPersistenceBackend;
import etm.core.aggregation.persistence.PersistentRootAggregator;
import etm.core.configuration.EtmMonitorFactory;
import etm.core.jmx.EtmMonitorJmxPlugin;
import etm.core.monitor.FlatMonitor;
import etm.core.monitor.NestedMonitor;
import etm.core.timer.DefaultTimer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class RuntimeBeanDefinitionParser
extends JetmBeanDefinitionParser {
    protected AbstractBeanDefinition parseInternal(Element aElement, ParserContext aParserContext) {
        BeanDefinitionBuilder builder;
        String type = aElement.getAttribute("type");
        String timer = aElement.getAttribute("timer");
        Element features = DomUtils.getChildElementByTagName((Element)aElement, (String)"features");
        Element aggregatorChain = DomUtils.getChildElementByTagName((Element)aElement, (String)"aggregator-chain");
        Element extension = DomUtils.getChildElementByTagName((Element)aElement, (String)"extension");
        if (type == null || type.length() == 0) {
            type = "nested";
        }
        if ("nested".equals(type)) {
            builder = BeanDefinitionBuilder.rootBeanDefinition((Class)NestedMonitor.class);
        } else if ("flat".equals(type)) {
            builder = BeanDefinitionBuilder.rootBeanDefinition((Class)FlatMonitor.class);
        } else {
            try {
                builder = BeanDefinitionBuilder.rootBeanDefinition(Class.forName(type));
            }
            catch (ClassNotFoundException e) {
                throw new FatalBeanException("Unable to locate monitor class " + type, (Throwable)e);
            }
        }
        if (timer != null && timer.length() > 0) {
            this.addTimerDefinition(timer, builder);
        }
        if (features != null) {
            this.buildChainFromFeatures(builder, features);
        } else if (aggregatorChain != null) {
            this.buildChainFromChain(builder, aggregatorChain);
        }
        if (extension != null) {
            if (features != null) {
                this.addExtensions(builder, extension, DomUtils.getChildElementByTagName((Element)features, (String)"jmx"));
            } else {
                this.addExtensions(builder, extension, null);
            }
        }
        builder.setInitMethodName("start");
        builder.setDestroyMethodName("stop");
        return builder.getBeanDefinition();
    }

    private void addExtensions(BeanDefinitionBuilder aBuilder, Element aExtension, Element jmx) {
        List pluginConfigs = DomUtils.getChildElementsByTagName((Element)aExtension, (String)"plugin");
        if (pluginConfigs.size() > 0) {
            ArrayList<AbstractBeanDefinition> plugins = new ArrayList<AbstractBeanDefinition>();
            for (int i = 0; i < pluginConfigs.size(); ++i) {
                BeanDefinitionBuilder builder;
                Element element = (Element)pluginConfigs.get(i);
                String clazz = element.getAttribute("class");
                try {
                    builder = BeanDefinitionBuilder.rootBeanDefinition(Class.forName(clazz));
                }
                catch (ClassNotFoundException e) {
                    throw new FatalBeanException("Unable to locate plugin class " + clazz, (Throwable)e);
                }
                List properties = DomUtils.getChildElementsByTagName((Element)element, (String)"property");
                if (properties.size() > 0) {
                    for (int j = 0; j < properties.size(); ++j) {
                        Element aProperty = (Element)properties.get(j);
                        this.addProperty(builder, aProperty);
                    }
                }
                plugins.add(builder.getBeanDefinition());
            }
            ManagedList list = new ManagedList(plugins.size());
            list.addAll(plugins);
            if (jmx != null) {
                String monitorObjectName = jmx.getAttribute("monitorObjectName");
                String mbeanServerName = jmx.getAttribute("mbeanServerName");
                String measurementDomain = jmx.getAttribute("measurementDomain");
                String overwrite = jmx.getAttribute("overwrite");
                BeanDefinitionBuilder jmxBuilder = BeanDefinitionBuilder.rootBeanDefinition((Class)EtmMonitorJmxPlugin.class);
                if (monitorObjectName != null && monitorObjectName.length() > 0) {
                    jmxBuilder.addPropertyValue("monitorObjectName", (Object)monitorObjectName);
                }
                if (mbeanServerName != null && mbeanServerName.length() > 0) {
                    jmxBuilder.addPropertyValue("mbeanServerName", (Object)mbeanServerName);
                }
                if (measurementDomain != null && measurementDomain.length() > 0) {
                    jmxBuilder.addPropertyValue("measurementDomain", (Object)measurementDomain);
                }
                if (overwrite != null && overwrite.length() > 0) {
                    jmxBuilder.addPropertyValue("overwrite", (Object)overwrite);
                }
                list.add((Object)jmxBuilder.getBeanDefinition());
            }
            aBuilder.addPropertyValue("plugins", (Object)list);
        }
    }

    private void buildChainFromChain(BeanDefinitionBuilder aBuilder, Element aAggregatorChain) {
        Class rootClazz;
        List chainElements = DomUtils.getChildElementsByTagName((Element)aAggregatorChain, (String)"chain-element");
        Element chainRoot = DomUtils.getChildElementByTagName((Element)aAggregatorChain, (String)"chain-root");
        if (chainRoot != null) {
            String rootClassName = chainRoot.getAttribute("class");
            try {
                rootClazz = Class.forName(rootClassName);
            }
            catch (ClassNotFoundException e) {
                throw new FatalBeanException("Unable to locate chain root class " + rootClassName, (Throwable)e);
            }
        } else {
            rootClazz = RootAggregator.class;
        }
        BeanDefinitionBuilder chainBuilder = BeanDefinitionBuilder.rootBeanDefinition((Class)rootClazz);
        if (chainElements.size() > 0) {
            for (int i = chainElements.size() - 1; i >= 0; --i) {
                BeanDefinitionBuilder nestedBuilder;
                Element chainElement = (Element)chainElements.get(i);
                String chainClassName = chainElement.getAttribute("class");
                try {
                    nestedBuilder = BeanDefinitionBuilder.rootBeanDefinition(Class.forName(chainClassName));
                }
                catch (ClassNotFoundException e) {
                    throw new FatalBeanException("Unable to locate chain element class " + chainClassName, (Throwable)e);
                }
                List propertyElements = DomUtils.getChildElementsByTagName((Element)chainElement, (String)"property");
                if (propertyElements.size() > 0) {
                    for (int j = 0; j < propertyElements.size(); ++j) {
                        Element property = (Element)propertyElements.get(j);
                        this.addProperty(nestedBuilder, property);
                    }
                }
                nestedBuilder.addConstructorArg((Object)chainBuilder.getBeanDefinition());
                chainBuilder = nestedBuilder;
            }
        }
        aBuilder.addConstructorArg((Object)chainBuilder.getBeanDefinition());
    }

    private void buildChainFromFeatures(BeanDefinitionBuilder runtimeBuilder, Element aElement) {
        BeanDefinitionBuilder bufferBuilder;
        BeanDefinitionBuilder aggregationRootBuilder;
        Element thresholdBufferElement = DomUtils.getChildElementByTagName((Element)aElement, (String)"threshold-buffer");
        Element intervalBuffer = DomUtils.getChildElementByTagName((Element)aElement, (String)"interval-buffer");
        Element notifications = DomUtils.getChildElementByTagName((Element)aElement, (String)"notifications");
        Element rawDataLog = DomUtils.getChildElementByTagName((Element)aElement, (String)"raw-data-log");
        Element persistence = DomUtils.getChildElementByTagName((Element)aElement, (String)"persistence");
        BeanDefinitionBuilder notificationBuilder = null;
        BeanDefinitionBuilder rawDataBuilder = null;
        if (notifications != null) {
            notificationBuilder = BeanDefinitionBuilder.rootBeanDefinition((Class)NotifyingAggregator.class);
            String rootOnly = notifications.getAttribute("rootOnly");
            String filterPattern = notifications.getAttribute("filter-pattern");
            if ("true".equals(rootOnly)) {
                notificationBuilder.addPropertyValue("rootOnly", (Object)"true");
            }
            if (filterPattern != null && filterPattern.length() > 0) {
                notificationBuilder.addPropertyValue("filterPattern", (Object)filterPattern);
            }
        }
        if (persistence != null) {
            BeanDefinitionBuilder backendBuilder;
            aggregationRootBuilder = BeanDefinitionBuilder.rootBeanDefinition((Class)PersistentRootAggregator.class);
            Element fileBackend = DomUtils.getChildElementByTagName((Element)persistence, (String)"file-backend");
            Element genericBackend = DomUtils.getChildElementByTagName((Element)persistence, (String)"custom-backend");
            if (fileBackend != null) {
                backendBuilder = BeanDefinitionBuilder.rootBeanDefinition((Class)FileSystemPersistenceBackend.class);
                String file = fileBackend.getAttribute("filename");
                String path = fileBackend.getAttribute("path");
                if (file != null && file.length() > 0) {
                    backendBuilder.addPropertyValue("filename", (Object)file);
                }
                if (path != null && path.length() > 0) {
                    backendBuilder.addPropertyValue("path", (Object)path);
                }
            } else if (genericBackend != null) {
                String className = genericBackend.getAttribute("class");
                try {
                    backendBuilder = BeanDefinitionBuilder.rootBeanDefinition(Class.forName(className));
                }
                catch (ClassNotFoundException e) {
                    throw new FatalBeanException("Unable to locate persistence backend class " + className, (Throwable)e);
                }
                List properties = DomUtils.getChildElementsByTagName((Element)genericBackend, (String)"property");
                Iterator iterator = properties.iterator();
                while (iterator.hasNext()) {
                    Element element = (Element)iterator.next();
                    this.addProperty(backendBuilder, element);
                }
            } else {
                backendBuilder = BeanDefinitionBuilder.rootBeanDefinition((Class)FileSystemPersistenceBackend.class);
            }
            aggregationRootBuilder.addPropertyValue("persistenceBackend", (Object)backendBuilder.getBeanDefinition());
        } else {
            aggregationRootBuilder = BeanDefinitionBuilder.rootBeanDefinition((Class)RootAggregator.class);
        }
        if (rawDataLog != null) {
            String logType = rawDataLog.getAttribute("type");
            String logCategory = rawDataLog.getAttribute("category");
            String logFormaterClass = rawDataLog.getAttribute("formatter-class");
            String filterPattern = rawDataLog.getAttribute("filter-pattern");
            if ("log4j".equals(logType)) {
                rawDataBuilder = BeanDefinitionBuilder.rootBeanDefinition((Class)Log4jAggregator.class);
            } else if ("commons".equals(logType)) {
                rawDataBuilder = BeanDefinitionBuilder.rootBeanDefinition((Class)CommonsLoggingAggregator.class);
            } else if ("jdk14".equals(logType)) {
                rawDataBuilder = BeanDefinitionBuilder.rootBeanDefinition((Class)Jdk14LogAggregator.class);
            } else {
                throw new BeanDefinitionStoreException("Raw logging type '" + logType + "' not supported");
            }
            if (logCategory != null && logCategory.length() > 0) {
                rawDataBuilder.addPropertyValue("logName", (Object)logCategory);
            }
            if (filterPattern != null && filterPattern.length() > 0) {
                rawDataBuilder.addPropertyValue("filterPattern", (Object)filterPattern);
            }
            if (logFormaterClass != null && logFormaterClass.length() > 0) {
                RootBeanDefinition definition = new RootBeanDefinition();
                definition.setBeanClassName(logFormaterClass);
                rawDataBuilder.addPropertyValue("formatter", (Object)definition);
            }
        }
        if (thresholdBufferElement != null) {
            bufferBuilder = BeanDefinitionBuilder.rootBeanDefinition((Class)BufferedThresholdAggregator.class);
            String threshold = thresholdBufferElement.getAttribute("threshold");
            if (threshold != null && threshold.length() > 0) {
                bufferBuilder.addPropertyValue("threshold", (Object)threshold);
            }
        } else if (intervalBuffer != null) {
            bufferBuilder = BeanDefinitionBuilder.rootBeanDefinition((Class)BufferedTimedAggregator.class);
            String interval = intervalBuffer.getAttribute("threshold");
            if (interval != null && interval.length() > 0) {
                bufferBuilder.addPropertyValue("interval", (Object)interval);
            }
        } else {
            bufferBuilder = BeanDefinitionBuilder.rootBeanDefinition((Class)BufferedThresholdAggregator.class);
        }
        BeanDefinitionBuilder chainBuilder = aggregationRootBuilder;
        if (rawDataBuilder != null) {
            rawDataBuilder.addConstructorArg((Object)chainBuilder.getBeanDefinition());
            chainBuilder = rawDataBuilder;
        }
        if (notificationBuilder != null) {
            notificationBuilder.addConstructorArg((Object)chainBuilder.getBeanDefinition());
            chainBuilder = notificationBuilder;
        }
        bufferBuilder.addConstructorArg((Object)chainBuilder.getBeanDefinition());
        chainBuilder = bufferBuilder;
        runtimeBuilder.addConstructorArg((Object)chainBuilder.getBeanDefinition());
    }

    private void addProperty(BeanDefinitionBuilder builder, Element aElement) {
        String name = aElement.getAttribute("name");
        String ref = aElement.getAttribute("ref");
        if (ref != null && ref.length() > 0) {
            builder.addPropertyReference(name, ref);
        } else {
            builder.addPropertyValue(name, (Object)DomUtils.getTextValue((Element)aElement));
        }
    }

    private void addTimerDefinition(String aTimer, BeanDefinitionBuilder builder) {
        if ("jdk15".equals(aTimer)) {
            try {
                Class<?> clazz = Class.forName("etm.core.timer.Java15NanoTimer");
                builder.addConstructorArg(clazz.newInstance());
            }
            catch (Exception e) {
                throw new FatalBeanException("Java15NanoTimer is not available for this platform. Please try 'sun' or 'default' instead.", (Throwable)e);
            }
        } else if ("sun".equals(aTimer)) {
            try {
                Class<?> clazz = Class.forName("etm.core.timer.SunHighResTimer. Please try 'jdk15' or 'default' instead.");
                builder.addConstructorArg(clazz.newInstance());
            }
            catch (Exception e) {
                throw new FatalBeanException("SunHighResTimer is not available for this platform.", (Throwable)e);
            }
        } else if ("default".equals(aTimer)) {
            builder.addConstructorArg((Object)new DefaultTimer());
        } else if ("bestAvailable".equals(aTimer)) {
            builder.addConstructorArg((Object)EtmMonitorFactory.bestAvailableTimer());
        } else {
            RootBeanDefinition timerBeanDefinition = new RootBeanDefinition();
            timerBeanDefinition.setBeanClassName(aTimer);
            builder.addConstructorArg((Object)timerBeanDefinition);
        }
    }
}

