/*
 * Decompiled with CFR 0.152.
 */
package etm.contrib.integration.web;

import etm.contrib.integration.web.EtmMonitorContextListener;
import etm.core.configuration.EtmManager;
import java.io.File;
import java.io.FileOutputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import junit.framework.TestCase;

public class EtmMonitorContextListenerTest
extends TestCase {
    public void testClassPath() throws Exception {
        EtmManager.reset();
        EtmMonitorContextListener listener = new EtmMonitorContextListener();
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("jetm.config.filename", "etm/contrib/integration/web/classpath-config.xml");
        ServletContext ctx = this.getServletContext(attributes);
        EtmMonitorContextListenerTest.assertTrue((boolean)Proxy.isProxyClass(EtmManager.getEtmMonitor().getClass()));
        listener.contextInitialized(new ServletContextEvent(ctx));
        EtmMonitorContextListenerTest.assertFalse((boolean)Proxy.isProxyClass(EtmManager.getEtmMonitor().getClass()));
        EtmMonitorContextListenerTest.assertTrue((boolean)EtmManager.getEtmMonitor().isStarted());
        listener.contextDestroyed(new ServletContextEvent(ctx));
        EtmMonitorContextListenerTest.assertFalse((boolean)EtmManager.getEtmMonitor().isStarted());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFilePath() throws Exception {
        File file = new File(System.getProperty("java.io.tmpdir"), "jetm-config.xml");
        try {
            FileOutputStream out = new FileOutputStream(file);
            out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE jetm-config PUBLIC \"-// void.fm //DTD JETM Config 1.0//EN\" \"http://jetm.void.fm/dtd/jetm_config_1_0.dtd\">\n<jetm-config>\n\n</jetm-config>".getBytes());
            EtmManager.reset();
            EtmMonitorContextListener listener = new EtmMonitorContextListener();
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put("jetm.config.filepath", file.getParentFile().getAbsolutePath());
            ServletContext ctx = this.getServletContext(attributes);
            EtmMonitorContextListenerTest.assertTrue((boolean)Proxy.isProxyClass(EtmManager.getEtmMonitor().getClass()));
            listener.contextInitialized(new ServletContextEvent(ctx));
            EtmMonitorContextListenerTest.assertFalse((boolean)Proxy.isProxyClass(EtmManager.getEtmMonitor().getClass()));
            EtmMonitorContextListenerTest.assertTrue((boolean)EtmManager.getEtmMonitor().isStarted());
            listener.contextDestroyed(new ServletContextEvent(ctx));
            EtmMonitorContextListenerTest.assertFalse((boolean)EtmManager.getEtmMonitor().isStarted());
        }
        finally {
            if (file.exists()) {
                file.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSystemPropertyPath() throws Exception {
        File file = new File(System.getProperty("java.io.tmpdir"), "jetm-config.xml");
        try {
            FileOutputStream out = new FileOutputStream(file);
            out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE jetm-config PUBLIC \"-// void.fm //DTD JETM Config 1.0//EN\" \"http://jetm.void.fm/dtd/jetm_config_1_0.dtd\">\n<jetm-config>\n\n</jetm-config>".getBytes());
            EtmManager.reset();
            EtmMonitorContextListener listener = new EtmMonitorContextListener();
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put("jetm.config.filepath", "${myapp.jetm.config}");
            System.setProperty("myapp.jetm.config", file.getParentFile().getAbsolutePath());
            ServletContext ctx = this.getServletContext(attributes);
            EtmMonitorContextListenerTest.assertTrue((boolean)Proxy.isProxyClass(EtmManager.getEtmMonitor().getClass()));
            listener.contextInitialized(new ServletContextEvent(ctx));
            EtmMonitorContextListenerTest.assertFalse((boolean)Proxy.isProxyClass(EtmManager.getEtmMonitor().getClass()));
            EtmMonitorContextListenerTest.assertTrue((boolean)EtmManager.getEtmMonitor().isStarted());
            listener.contextDestroyed(new ServletContextEvent(ctx));
            EtmMonitorContextListenerTest.assertFalse((boolean)EtmManager.getEtmMonitor().isStarted());
        }
        finally {
            if (file.exists()) {
                file.delete();
            }
        }
    }

    private ServletContext getServletContext(final Map contextAttributes) throws Exception {
        InvocationHandler handler = new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.getName().equals("toString")) {
                    return (class$javax$servlet$ServletContext == null ? (class$javax$servlet$ServletContext = EtmMonitorContextListenerTest.class$("javax.servlet.ServletContext")) : class$javax$servlet$ServletContext).getName();
                }
                return contextAttributes.get(args[0]);
            }
        };
        return (ServletContext)Proxy.newProxyInstance(((Object)((Object)this)).getClass().getClassLoader(), new Class[]{ServletContext.class}, handler);
    }
}

