/*
 * Decompiled with CFR 0.152.
 */
package etm.contrib.integration.web;

import etm.contrib.integration.web.HttpRequestPerformanceFilterTest;
import etm.contrib.integration.web.SoapActionPerformanceFilter;
import etm.core.aggregation.Aggregate;
import etm.core.configuration.EtmManager;
import etm.core.renderer.MeasurementRenderer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import junit.framework.TestCase;
import org.apache.log4j.BasicConfigurator;

public class SoapActionPerformanceFilterTest
extends HttpRequestPerformanceFilterTest {
    public void setUp() throws Exception {
        EtmManager.reset();
        BasicConfigurator.configure();
        this.filter = new SoapActionPerformanceFilter();
        this.filter.init(null);
        this.etmMonitor = EtmManager.getEtmMonitor();
        this.etmMonitor.start();
    }

    public void tearDown() {
        this.etmMonitor.stop();
    }

    public void testSoapActionMonitoring() throws Exception {
        this.filter.doFilter(this.getSoapActionRequest(), null, this.getFilterChain());
        this.etmMonitor.render(new MeasurementRenderer(){

            public void render(Map points) {
                String key = "SoapAction ASoapRequest";
                TestCase.assertTrue((boolean)points.containsKey(key));
                Aggregate aggregate = (Aggregate)points.get(key);
                TestCase.assertEquals((long)1L, (long)aggregate.getMeasurements());
                TestCase.assertEquals((double)15.0, (double)aggregate.getMin(), (double)0.0);
            }
        });
    }

    private ServletRequest getSoapActionRequest() throws Exception {
        return (ServletRequest)Proxy.newProxyInstance(((Object)((Object)this)).getClass().getClassLoader(), new Class[]{HttpServletRequest.class}, new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.getName().equals("toString")) {
                    return (class$javax$servlet$http$HttpServletRequest == null ? (class$javax$servlet$http$HttpServletRequest = SoapActionPerformanceFilterTest.class$("javax.servlet.http.HttpServletRequest")) : class$javax$servlet$http$HttpServletRequest).getName();
                }
                if (method.getName().equals("getHeader") && args[0].equals("SoapAction")) {
                    return "ASoapRequest";
                }
                return null;
            }
        });
    }
}

