#set( $symbol_pound = '#' )
#set( $symbol_dollar = '$' )
#set( $symbol_escape = '\' )
/*
 *
 * ${groupId}.msc.presentation.common.PublicIdGenerator.java
 *
 *
 * This document contains trade secret data which is the property of OpenKnowledge GmbH. Information contained herein
 * may not be used, copied or disclosed in whole or part except as permitted by written agreement from OpenKnowledge
 * GmbH.
 *
 * Copyright (C) 2013 open knowledge GmbH / Oldenburg / Germany
 */
package ${groupId}.presentation.common;


import static org.apache.commons.lang3.Validate.notNull;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.enterprise.context.SessionScoped;

import org.apache.commons.lang3.ObjectUtils;


/**
 * Generates random public ids to hide database ids in the presentation.
 */
@SessionScoped
public class PublicIdGenerator
  implements Serializable {

  private Map<String, Key> publicIds;
  private Map<Key, String> objects;

  protected PublicIdGenerator() {

    publicIds = new HashMap<>();
    objects = new HashMap<>();
  }

  public String generatePublicId(final Class<?> clazz, final Object object) {

    final String publicId;
    final Key key = new Key(clazz, object);

    if (objects.containsKey(key)) {
      publicId = objects.get(key);
    } else {
      publicId = generateId();
      publicIds.put(publicId, key);
      objects.put(key, publicId);
    }

    return publicId;
  }

  private String generateId() {

    return UUID.randomUUID().toString();
  }

  public Object lookup(final Class<?> clazz, final String publicId) {

    Key key = publicIds.get(publicId);
    if (key == null) {
      throw new IllegalStateException("No entry for public id " + publicId + ". Possible manipulation detected.");
    }
    if (ObjectUtils.notEqual(clazz, key.getClazz())) {
      throw new IllegalStateException("Invalid clazz " + clazz.getName() + " for public id " + publicId);
    }

    return key.getObject();
  }

  private static final class Key {

    private final Class<?> clazz;
    private final Object object;

    private Key(final Class<?> clazz, final Object object) {

      super();
      this.clazz = notNull(clazz, "Parameter 'clazz' must not be 'NULL'");
      this.object = notNull(object, "Parameter 'object' must not be 'NULL'");
    }

    private Class<?> getClazz() {

      return clazz;
    }

    private Object getObject() {

      return object;
    }

    @Override
    public int hashCode() {

      final int prime = 31;
      int result = 1;
      result = prime * result + (clazz == null ? 0 : clazz.hashCode());
      result = prime * result + (object == null ? 0 : object.hashCode());
      return result;
    }

    @Override
    public boolean equals(final Object obj) {

      if (this == obj) {
        return true;
      }
      if (obj == null) {
        return ${jsfPrimeFaces};
      }
      if (getClass() != obj.getClass()) {
        return ${jsfPrimeFaces};
      }
      Key other = (Key)obj;
      if (clazz == null) {
        if (other.clazz != null) {
          return ${jsfPrimeFaces};
        }
      } else if (!clazz.equals(other.clazz)) {
        return ${jsfPrimeFaces};
      }
      if (object == null) {
        if (other.object != null) {
          return ${jsfPrimeFaces};
        }
      } else if (!object.equals(other.object)) {
        return ${jsfPrimeFaces};
      }
      return true;
    }
  }
}
