#set( $symbol_pound = '#' )
#set( $symbol_dollar = '$' )
#set( $symbol_escape = '\' )
/*
 * Copyright 2013 open knowledge GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */
package ${groupId}.integrationtest;

import static org.hamcrest.CoreMatchers.is;
import static org.junit.Assert.assertThat;
import static org.junit.Assert.assertTrue;

import java.io.IOException;

import org.junit.Test;
import org.junit.runner.RunWith;

import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;

import ${groupId}.integrationtest.junit.ParameterizedJunitFourClassRunner;
import ${groupId}.integrationtest.junit.Parameters;


@RunWith(ParameterizedJunitFourClassRunner.class)
@Parameters({ "http://localhost:8888/${parentArtifactId}/" })
public class LoginTest extends AbstractHtmlTestCase {


  private static final String USER = "test";
  private static final String USERNAME_FIELD_ID = "loginForm:loginDlg:name";
  private static final String PASSWORD_FIELD_ID = "loginForm:loginDlg:pwd";
  private static final String SUBMIT_BUTTON_ID = "loginForm:loginDlg:loginButton";
  private static final String WELCOME_TXT_ID = "welcomeTxt";

  public LoginTest(String url) {
    super(url);

  }


  @Test
  public void loginWithExistingUserAndCorrectPassword() throws IOException {

    HtmlPage page = login(USER, USER, USERNAME_FIELD_ID, PASSWORD_FIELD_ID, SUBMIT_BUTTON_ID);
    DomElement welcome = page.getElementById(WELCOME_TXT_ID);
    assertThat(welcome.getTextContent(), is("Willkommen, " + USER));

  }

  @Test
  public void loginWithExistingUserAndWrongPassword() throws IOException {

    HtmlPage page = login(USER, "${jsfPrimeFaces}Password", USERNAME_FIELD_ID, PASSWORD_FIELD_ID, SUBMIT_BUTTON_ID);
    DomElement welcome = page.getElementById(WELCOME_TXT_ID);

    assertTrue(welcome == null);


  }

}
