/*
 * Decompiled with CFR 0.152.
 */
package de.openknowledge.cdi.transaction.jta;

import de.openknowledge.cdi.transaction.jta.AbstractTransactionAttributeInterceptor;
import de.openknowledge.cdi.transaction.jta.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.TransactionRequiredException;

@TransactionAttribute(value=TransactionAttributeType.REQUIRED)
@Interceptor
public class RequiredTransactionInterceptor
extends AbstractTransactionAttributeInterceptor {
    @AroundInvoke
    public Object applyTransaction(InvocationContext ic) throws Exception {
        boolean transactionStarted = this.beginTransactionIfNeeded();
        try {
            Object result;
            Object object = result = ic.proceed();
            return object;
        }
        catch (Exception e) {
            this.rollbackTransactionIfNeeded(transactionStarted, e);
            throw e;
        }
        finally {
            this.handleTransactionEnd(transactionStarted);
        }
    }

    protected boolean beginTransactionIfNeeded() throws TransactionRequiredException, NotSupportedException, SystemException {
        if (!this.isTransactionActive()) {
            this.beginTransaction();
            return true;
        }
        return false;
    }
}

